/**
 * Project Name:qiho-center-biz
 * File Name:ErpOrderService.java
 * Package Name:com.qiho.center.biz.service.order
 * Date:2017年6月6日上午11:58:41
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import java.util.List;

import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;

/**
 * ClassName:ErpOrderService <br/>
 * ERP服务. <br/>
 * Date:     2017年6月6日 上午11:58:41 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ErpOrderService {

    /**
     * 根据订单ID查询ERP信息
     *
     * @author zhanglihui
     * @param orderId
     * @return List<ErpOrderDto>
     */
    List<ErpOrderDto> findByOrderId(String orderId);

    /**
     * 查询ERP子订单的分页
     * @param params
     * @return
     */
    PagenationDto<ErpOrderDto> findErpOrderPage(ErpOrderPageParams params);

    /**
     * 创建ERP子订单
     * @param order
     * @return
     */
    ErpOrderDto createErpOrder(QihoErpOrderEntity order);

    /**
     * 查询单个ERP子订单
     * @param erpId
     * @return
     */
    ErpOrderDto findErpOrderByErpId(String erpId);

    /**
     * ERP取消发货
     * @param erpId
     */
    ErpOrderDto cancelDeliver(String erpId);

    /**
     * 确认发货
     * @param erpId
     * @return
     */
    ErpOrderDto resolveDeliver(String erpId);
}

