/**
 * Project Name:qiho-center-biz
 * File Name:FundOrderService.java
 * Package Name:com.qiho.center.biz.service.order
 * Date:2017年6月6日下午1:02:33
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import java.util.List;

import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.FundPageParam;

/**
 * ClassName:FundOrderService <br/>
 * Date:     2017年6月6日 下午1:02:33 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface FundOrderService {

    /**
     * 根据订单ID查询资金流水
     *
     * @author zhanglihui
     * @param orderId
     * @return List<FundOrderDto>
     */
    List<FundOrderDto> findByOrderId(String orderId);

    /**
     * 分页查询资金流水
     * @author zhanglihui
     * @param param
     * @return PagenationDto<FundOrderDto>
     */
    PagenationDto<FundOrderDto> queryFundPage(FundPageParam param);

    /**
     * 初始化付款子订单(没有账号和外部流水号)
     * @param order
     */
    void initFundOrder(OrderDto order);

    /**
     * 更新资金流水状态
     *
     * @author chencheng
     * @param orderId
     * @param fundStatus
     * @return
     */
    Integer updateFundOrderStatus(String orderId, String fundStatus);
}

