package com.qiho.center.biz.service.order;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderPageParams;

import java.util.List;

/**
 * Created by liuyao on 2017/6/3.
 */
public interface OrderSnapshotService {

    public PagenationDto<OrderSnapshotDto> findOrderPage(OrderPageParams params);

    public List<OrderSnapshotDto> findOrderPageForExport(OrderPageParams params);

    public Integer findAllPageCount(OrderPageParams params);
    /**
     * 根据订单ID查询订单快照
     * @author zhanglihui
     * @param orderId
     * @return OrderSnapshotDto
     */
    public OrderSnapshotDto findByOrderId(String orderId);

    /**
     * 查询导出订单总数(远远大于真实总数)
     * @param params
     * @return
     */
    public Integer exportOrderPageCount(OrderPageParams params);

    /**
     * 更新
     * @param orderId
     * @param orderStatus
     * @return
     */
    public Integer updateOrderStatus(String orderId, OrderStatusEnum orderStatus);

}
