package com.qiho.center.biz.engine;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;

/**
 * Created by danke on 2017/6/21.
 * 操作链路基类,具体处理由子类完成
 */
public interface BaseHandler {


    /**
     * 链路执行方法
     * @param context
     * @return
     */
    ResultBase<Boolean> handleRequest(ProcessContext context);

    /**
     * 获取订单中需要校验字段的值
     * @param orderSnapshotDto
     * @param strategyRuleDto
     * @return
     * @throws IllegalAccessException
     */
    static String getValuteVal(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) throws IllegalAccessException {
        if (null == orderSnapshotDto || null == strategyRuleDto)
            return null;
        String[] valuteFieldNameArr = strategyRuleDto.getFieldName().split("-");
        String valuteFieldName = valuteFieldNameArr[valuteFieldNameArr.length-1];
        Field[] fields = orderSnapshotDto.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (fieldName.equals(valuteFieldName)) {
                Object fieldValue = field.get(orderSnapshotDto);
                return fieldValue == null ? null : String.valueOf(fieldValue);
            }
        }
        return StringUtils.EMPTY;
    }
}
