package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderStrategyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by qianjue on 2017/8/2.
 */
public abstract class BaseOrderEngine {

	@Resource
	OrderStrategyService orderStrategyService;

	@Resource
	private OrderService orderService;

	public List<OrderStrategyDto> getOrderStrategyList(StrategyType strategyType){
		OrderStrategyParams params = new OrderStrategyParams();
		params.setStrategyType(strategyType.getCode());
		return orderStrategyService.findStrategyByQuery(params,null,null).getList();
	}

	/**
	 * 校验策略是否为空
	 * @param orderStrategyDto
	 * @return
	 * @throws Exception
	 */
	protected ResultBase<List<StrategyRuleDto>> validateorderStrategyDto(OrderStrategyDto orderStrategyDto){
		ResultBase<List<StrategyRuleDto>> resultBase = new ResultBase<>();
		if(StringUtils.isBlank(orderStrategyDto.getRulevalue()))
			return resultBase.setErrorReturn("策略为空,不校验");
		List<StrategyRuleDto> strategyRuleDtos = JSONObject.parseArray(orderStrategyDto.getRulevalue(),StrategyRuleDto.class);
		if(CollectionUtils.isEmpty(strategyRuleDtos))
			return resultBase.setErrorReturn("此策略的策略规则值为空,不校验 strategyName="+orderStrategyDto.getStrategyName());
		return resultBase.setRightReturn(strategyRuleDtos);
	}


	protected void auditOrderPass(String orderId){
		OrderAuditParams params = new OrderAuditParams();
		params.setOrderId(orderId);
		params.setAuditResult(OrderAuditParams.AUDIT_SUCCESS);
		orderService.auditOrder(params);
	}

}
