package com.qiho.center.biz.job;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.LogisticsOrderBo;

/**
 * 定时任务，去ERP系统查询物流发货信息. date: 2017年6月8日 下午4:49:50 <br/>
 *
 * @author chencheng
 * @version
 */
@Component
public class ErpLogisticsSyncQueryTaskJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(ErpLogisticsSyncQueryTaskJob.class);

    @Autowired
    private LogisticsOrderBo    logisticsOrderBo;

    /**
     * @see com.qiho.center.biz.job.AbstractQihoSimpleElasticJob#doProcess(com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext)
     */
    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.warn("ErpLogisticsSyncQueryJob   启动成功");
        logisticsOrderBo.erpLogisticsSyncQuery();
        LOGGER.info("############## ERP物流信息同步成功(ErpLogisticsSyncQueryTaskJob 执行成功)】##############");
    }

}
