package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.DetailRecommendDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.remoteservice.RemoteDetailRecommendService;
import com.qiho.center.biz.service.DetailRecommendService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2017-09-20 13:52
 **/
@RestController
public class RemoteDetailRecommendServiceImpl implements RemoteDetailRecommendService{

    private static final Logger LOG = LoggerFactory.getLogger(RemoteDetailRecommendServiceImpl.class);

    @Autowired
    private DetailRecommendService detailRecommendService;

    @Override
    public DubboResult<List<DetailRecommendDto>> findByItemId(Long itemId) {
        try{
            return DubboResult.successResult(detailRecommendService.findListByItemId(itemId));
        }catch (Exception e){
            LOG.error("invoke RemoteDetailRecommendServiceImpl.findByItemId failed, itemId={}", itemId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<DetailRecommendDto>> queryDetailRecommend(Long itemId) {
        try{
            return DubboResult.successResult(detailRecommendService.queryDetailRecommend(itemId));
        }catch (Exception e){
            LOG.error("invoke RemoteDetailRecommendServiceImpl.queryDetailRecommed failed, itemId={}", itemId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> saveDetailRecommend(List<DetailRecommendDto> dtos) {
        try {
            boolean result = detailRecommendService.saveDetailRecommend(dtos);
            if(result){
                return DubboResult.successResult(result);
            }else{
                return DubboResult.failResult("保存失败");
            }
        }catch (Exception e){
            LOG.error("invoke RemoteDetailRecommendServiceImpl.saveDetailRecommed failed, dtos={}", dtos, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ItemSimpleDto> queryItemDetail(Long itemId) {
        try {
            return DubboResult.successResult(detailRecommendService.queryItemDetail(itemId));
        }catch (Exception e){
            LOG.error("invoke RemoteDetailRecommendServiceImpl.queryItemDetail failed, itemId={}", itemId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
