package com.qiho.center.biz.remoteservice.impl.campaign;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaPlanDto;
import com.qiho.center.api.enums.ResultErrorEnum;
import com.qiho.center.api.params.MediaPlanParams;
import com.qiho.center.api.remoteservice.campaign.RemoteMediaPlanService;
import com.qiho.center.biz.service.MediaPlanService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by danke on 2017/6/16.
 */
@RestController
public class RemoteMediaPlanServiceImpl implements RemoteMediaPlanService {

    Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MediaPlanService mediaPlanService;

    @Override
    public DubboResult<PagenationDto<MediaPlanDto>> queryMediaPlanByPage(MediaPlanParams params,Integer pageNum,Integer pageSize) {
        if (null == params)
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        try{
            PagenationDto<MediaPlanDto> mediaPlanPageResult = mediaPlanService.findByQuery(params,pageNum,pageSize);
            return DubboResult.successResult(mediaPlanPageResult);
        }catch (Exception e){
            logger.error("媒体计划分页查询异常 params={}",params.toString(),e);
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteMediaPlanById(Long id) {
        if(null == id || id < 0)
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        try{
            MediaPlanDto resultDto = mediaPlanService.findById(id);
            if(null == resultDto)//id有误,需更新记录为null
                return DubboResult.failResult("需要删除的媒体计划不存在");
            Integer resultIte = mediaPlanService.deleteMediaById(id);
            if (null != resultIte && resultIte > 0)
                return DubboResult.successResult(Boolean.TRUE);
            return DubboResult.failResult(ResultErrorEnum.RESULT_ERROR.getMessage());
        }catch (Exception e){
            logger.error("通过id删除媒体计划失败 id={}",id,e);
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateMediaPlanByParam(MediaPlanDto mediaPlanDto) {
        if(null == mediaPlanDto || null == mediaPlanDto.getId() || StringUtils.isBlank(mediaPlanDto.getMediaName()))
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        try{
            MediaPlanDto resultDto = mediaPlanService.findById(mediaPlanDto.getId());
            if(null == resultDto)//id有误,需更新记录为null
                return DubboResult.failResult("需要更新的媒体计划不存在 ");
            //验证是否重复
            if(checkMediaPlanName(mediaPlanDto))
                return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage()+"媒体计划名称重复");
            Integer resultBase = mediaPlanService.updateMediaPlan(mediaPlanDto);
            if (null != resultBase && resultBase > 0)
                return DubboResult.successResult(Boolean.TRUE);
            return DubboResult.failResult(ResultErrorEnum.RESULT_ERROR.getMessage());
        }catch (Exception e){
            logger.error("更新媒体计划信息失败 mediaPlanDto={}",mediaPlanDto.getId(),e);
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> insertMediaPlan(MediaPlanDto mediaPlanDto) {
        if(valuteParamsNull(mediaPlanDto))//校验参数
            return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage());
        try {
            //验证是否重复
            if(checkMediaPlan(mediaPlanDto) || checkMediaPlanName(mediaPlanDto))
                return DubboResult.failResult(ResultErrorEnum.PARAMS_ERROR.getMessage()+"媒体计划名称或qiho_code重复");
            Integer channelId = mediaPlanService.insertMediaPlan(mediaPlanDto);
            if (null != channelId || channelId > 0)
                return DubboResult.successResult(channelId);
            return DubboResult.failResult(ResultErrorEnum.RESULT_ERROR.getMessage());
        }catch (Exception e){
            logger.error("新增媒体计划信息失败 mediaPlanDto={}",mediaPlanDto.getMediaName(),e);
            return DubboResult.failResult(ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> countByParam(MediaPlanParams params) {
        if (null == params)
            return DubboResult.failResult("查询条件参数为空");
        try{
            Integer total = mediaPlanService.countMediaPlanByQuery(params);
            return DubboResult.successResult(total);
        }catch (Exception e){
            logger.error("条件查询记录数error,params={}", JSON.toJSONString(params),e);
            return DubboResult.failResult("条件查询记录数error");
        }
    }

    /**
     * 校验qiho_code是否重复
     * @param mediaPlanDto
     * @return
     */
    private Boolean checkMediaPlan(MediaPlanDto mediaPlanDto){
        MediaPlanParams planParamsCode = new MediaPlanParams();
        //验证qiho_code
        planParamsCode.setQihoCode(mediaPlanDto.getQihoCode());
        PagenationDto<MediaPlanDto> codeResult = mediaPlanService.findByQuery(planParamsCode,null,null);
        if(CollectionUtils.isEmpty(codeResult.getList()))
            return Boolean.FALSE;
        return  Boolean.TRUE;
    }

    /**
     * 校验对应渠道下的媒体计划名称是否重复
     */
    private Boolean checkMediaPlanName(MediaPlanDto mediaPlanDto){
        MediaPlanParams planParamsChannel = new MediaPlanParams();
        planParamsChannel.setChannelId(mediaPlanDto.getChannelId());
        planParamsChannel.setMediaName(mediaPlanDto.getMediaName());
        PagenationDto<MediaPlanDto> channelResult = mediaPlanService.findByQuery(planParamsChannel,null,null);
        if(CollectionUtils.isEmpty(channelResult.getList()))
            return Boolean.FALSE;
        Long resultCopy = channelResult.getList().stream().filter(e -> mediaPlanDto.getMediaName().equals(e.getMediaName())).count();
        if(resultCopy <= 0)
            return  Boolean.FALSE;
        return Boolean.TRUE;
    }





    /**
     * 校验新增操作dto数据完整
     * 媒体计划不为null信息
     * id,name,creator,status,gmt_created
     */
    private Boolean valuteParamsNull(MediaPlanDto mediaPlanDto){
        if(null == mediaPlanDto)
            return Boolean.TRUE;
        if(null != mediaPlanDto.getId() && mediaPlanDto.getId() > 0)
            return Boolean.TRUE;
        if(StringUtils.isBlank(mediaPlanDto.getMediaName()) || StringUtils.isBlank(mediaPlanDto.getCreator()))
            return Boolean.TRUE;
        if(null == mediaPlanDto.getChannelId() || mediaPlanDto.getChannelId() <= 0)
            return Boolean.TRUE;
        if(StringUtils.isBlank(mediaPlanDto.getChannelName()))
            return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
