package com.qiho.center.biz.remoteservice.impl.campaign;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaWhiteListDto;
import com.qiho.center.api.params.MediaWhiteListQueryParam;
import com.qiho.center.api.remoteservice.campaign.RemoteMediaWhiteListService;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.common.entity.campaign.QihoMediaWhiteListEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by qianjue on 2017/9/8.
 */
@RestController
public class RemoteMediaWhiteListServiceImpl implements RemoteMediaWhiteListService {

	private  static Logger logger = LoggerFactory.getLogger(RemoteMediaWhiteListServiceImpl.class);

	@Resource
	private MediaWhiteListService mediaWhiteListService;

	@Override
	public DubboResult<Long> saveOrUpdateWhiteList(MediaWhiteListDto whiteListDto) {
		try{
			return DubboResult.successResult(mediaWhiteListService.saveOrUpdateWhiteList(whiteListDto));
		}catch (Exception e) {
			logger.error("RemoteMediaWhiteListServiceImpl call saveOrUpdateWhiteList error,param = {}",
					JSON.toJSONString(whiteListDto),e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Integer> deleteWhiteListById(Long id) {
		try{
			return  DubboResult.successResult(mediaWhiteListService.deleteWhiteListById(id));
		}catch (Exception e) {
			logger.error("RemoteMediaWhiteListServiceImpl call deleteWhiteListById error, id = {}",id,e);
			return  DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<PagenationDto<MediaWhiteListDto>> queryWhiteListPage(MediaWhiteListQueryParam param){
		try{
			return DubboResult.successResult(mediaWhiteListService.queryWhiteListPage(param));
		}catch (Exception e) {
			logger.error("RemoteMediaWhiteListServiceImpl call queryWhiteListPage error,param = {}",JSON.toJSONString(param),e);
			return DubboResult.failResult(e.getMessage());
		}
	}


	@Override
	public DubboResult<MediaWhiteListDto> selectWhiteListById(Long id) {
		try{
			QihoMediaWhiteListEntity entity = mediaWhiteListService.selectWhiteById(id);
			return DubboResult.successResult(BeanUtils.copy(entity,MediaWhiteListDto.class));
		}catch(Exception e){
			logger.error("RemoteMediaWhiteListServiceImpl call selectWhiteListById error, id = {}",id,e);
			return DubboResult.failResult(e.getMessage());
		}
	}
}
