/**
 * Project Name:qiho-center-biz
 * File Name:RemoteChannelInfoServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl.order
 * Date:2017年6月6日下午12:07:44
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl.order;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.remoteservice.order.RemoteChannelInfoService;
import com.qiho.center.biz.service.order.ChannelInfoService;
import org.springframework.web.bind.annotation.RestController;


/**
 * ClassName:RemoteChannelInfoServiceImpl <br/>
 * Date:     2017年6月6日 下午12:07:44 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@RestController
public class RemoteChannelInfoServiceImpl implements RemoteChannelInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteChannelInfoServiceImpl.class);
    @Autowired
    private ChannelInfoService channelInfoService;
    
    @Override
    public DubboResult<ChannelInfoDto> findByOrderId(String orderId) {
        try{
            ChannelInfoDto channelInfoDto = channelInfoService.findByOrderId(orderId);
            return DubboResult.successResult(channelInfoDto);
        }catch(Exception e){
            LOG.error("invoke RemoteChannelInfoService.findByOrderId failed,orderId={}",orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

