package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by danke on 2017/9/8.
 * 用于向云片进行http请求发送短信的任务类
 */
@Component
@Scope("prototype")
public class YunPianNoteSendRunnable implements Callable<Boolean> {

    private static final Logger LOGGER = LoggerFactory.getLogger(YunPianNoteSendRunnable.class);

    private List<OrderSnapshotDto> orderSnapshotDtos;

    private QihoTemplateEntity noteTemplate;//短信模板

    @Resource
    private SmsService smsService;//短信发送服务

    @Resource
    private QihoTemplateDAO qihoTemplateDAO;//模板查询服务

    @PostConstruct
    public void init(){
        QihoTemplateEntity template = qihoTemplateDAO.findByCode(SmsTemplateEnum.NOTE_GAIN.getCode());
        if (template.getTemplateEnable())
            noteTemplate = template;
    }

    @Override
    public Boolean call() throws Exception {
        if (CollectionUtils.isEmpty(orderSnapshotDtos) || null == noteTemplate)
            return Boolean.FALSE;
        try{
            for (OrderSnapshotDto orderSnapshotDto : orderSnapshotDtos){
                Map<String, String> context = Maps.newHashMap();
                context.put("name", orderSnapshotDto.getConsumerName());//购买人姓名
                context.put("create", DateUtils.getSecondStr(orderSnapshotDto.getGmtCreate()));//下单时间
                context.put("amt", String.valueOf(orderSnapshotDto.getOrderAmt()/100));//订单金额,展示元
                context.put("itemName", orderSnapshotDto.getItemShortName());//商品名称
                smsService.singleSend(noteTemplate,context, orderSnapshotDto.getMobile());
            }
        }catch (Exception e){
            LOGGER.error("短信捞单发送短信异常 params={}",orderSnapshotDtos,e);
        }
        return Boolean.TRUE;
    }

    public List<OrderSnapshotDto> getOrderSnapshotDtos() {
        return orderSnapshotDtos;
    }

    public void setOrderSnapshotDtos(List<OrderSnapshotDto> orderSnapshotDtos) {
        this.orderSnapshotDtos = orderSnapshotDtos;
    }

    public void setOrderSnapshotDtos(OrderSnapshotDto orderSnapshotDto){
        this.orderSnapshotDtos = Lists.newArrayList(orderSnapshotDto);
    }

    public QihoTemplateEntity getNoteTemplate() {
        return noteTemplate;
    }

    public void setNoteTemplate(QihoTemplateEntity noteTemplate) {
        this.noteTemplate = noteTemplate;
    }
}
