/**
 * Project Name:qiho-center-biz
 * File Name:ItemService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年5月18日上午10:09:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service;

import java.util.List;
import java.util.Set;

import com.qiho.center.api.dto.*;

/**
 * ClassName:ItemService <br/>
 * Date:     2017年5月18日 上午10:09:20 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ItemService {

    /**
     * 分页查询商品列表
     * @author zhanglihui
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return PagenationDto<ItemDto>
     */
    PagenationDto<ItemDto> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize);

    /**
     * 创建商品
     * @author zhanglihui
     * @param itemDetail
     * @return 商品ID
     */
    Long createItem(ItemDetailDto itemDetail);

    /**
     * 更新商品信息
     * @author zhanglihui
     * @param itemDetail
     */
    void updateItem(ItemDetailDto itemDetail);

    /**
     * 查询商品详情
     * @author zhanglihui
     * @param itemId
     * @return ItemDetailDto
     */
    ItemDetailDto queryItemDetail(Long itemId);

    /**
     * 批量更新商品状态
     * @author zhanglihui
     * @param itemIds
     * @param status
     */
    void updateStatus(List<Long> itemIds, String status);

    /**
     * 批量删除商品
     * @author zhanglihui
     * @param itemIds
     */
    void deleteBatch(List<Long> itemIds);

    /**
     * 根据ids获取的ItemDto
     * @param itemIds
     * @return List<ItemDto>
     */
    List<ItemDto> findItemDtoByItemIds(Set<Long> itemIds);

    /**
     * 查询首页推荐商品
     * @author zhanglihui
     * @return List<ItemDto>
     */
    List<ItemDto> findRecommendIndex();

    /**
     * 查询商品基本信息
     * @author zhanglihui
     * @param itemId
     * @return ItemSimpleDto
     */
    ItemSimpleDto queryItemSimpleDto(Long itemId);


    List<ItemSimpleDto> queryItemSimpleList(ItemDto queryItem);

    /**
     * 根据商品id更新商品扩展信息extparam
     */
    void updateExtParamByItemId(ItemAdvertDto dto);

    /**
     * 根据商品id查询商品扩展信息
     */
    ItemAdvertDto queryExtParamByItemId(Long itemId);
}

