package com.qiho.center.biz.service;

import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncAckDto;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;

import java.util.List;


/**
 * ClassName: LogisticsOrderService <br/>
 * date: 2017年6月6日 下午12:50:55 <br/>
 *
 */
public interface LogisticsOrderService {

    /**
     * 初始化物流子订单(手动发货初始化物流子订单)
     * @param erp
     * @return
     */
    void initLogisticsOrder(ErpOrderDto erp, ResolveDeliverParams params);

    /**
     * 分页查询物流子订单
     *
     * @author chencheng
     * @param queryItem 
     * @param pageNum
     * @param pageSize
     * @return PagenationDto<LogisticsOrderDto>
     */
    PagenationDto<LogisticsOrderDto> queryLogisticsOrderPage(QueryLogisticsOrderDto queryItem, Integer pageNum,
                                                             Integer pageSize);
    /**
     * 更新订单状态
     *
     * @author chencheng
     * @param logisticsId
     * @param orderStatus
     * @return Integer
     */
    Integer updateBylogisticsId(String logisticsId, String orderStatus);
    
    /**
     * 根据订单ID查询物流信息
     * @author zhanglihui
     * @param orderId
     * @return List<LogisticsOrderDto>
     */
    List<LogisticsOrderDto> findByOrderId(String orderId);
    
    /**
     * 根据erpId查询物流信息
     *
     * @author chencheng
     * @param erpId
     * @return
     */
    LogisticsOrderDto findByErpId(String erpId);
    
    /**
     * 根据物流订单ID查询物流信息
     * @author zhanglihui
     * @param orderId
     * @return List<LogisticsOrderDto>
     */
    LogisticsOrderDto findByLogisticsId(String logisticsId);
    
    /**
     * 根据物流单号和物流公司代码查询物流信息
     * @author zhanglihui
     * @param orderId
     * @return List<LogisticsOrderDto>
     */
    LogisticsOrderDto findByPostIdCode(String postId, String logisticsCode);
    
    /**
     * 更新物流子订单物流状态</br>
     *
     * @author chencheng
     * @param logisticsOrderDto
     * @return
     */
    Integer update(LogisticsOrderDto logisticsOrderDto);
    
    /**
     * 同步ERP物流信息，创建物流子订单，更新ERP子订单状态
     * @author zhanglihui
     * @param list
     * @return List<ErpLogisticsSyncAckDto>
     */
    List<ErpLogisticsSyncAckDto> createLogisticsOrderBatch(List<ErpLogisticsSyncDto> list);

    /**
     * 将指定状态的物流订单批量同步
     *
     * @author zhanglihui
     * @param logisticsOrderStatus
     */
    public void syncLogisticsStatus(String logisticsOrderStatus);
    
    /**
     * 同步物流状态
     *
     * @author zhanglihui
     * @param list
     */
    public void doSync(List<LogisticsOrderEntity> list);

    /**
     * 全部签收失败状态的订单以及创建时间超过2天的派件中订单做二次验证
     * @author zhanglihui
     * @param pageNum
     * @param pageSize
     * @param minId 
     * @return
     */
    List<LogisticsOrderEntity> queryListToFix(int pageNum, int pageSize, long minId);


    int queryDistributeOverTimeNum();


    List<LogisticsOrderDto> queryDistributeOverTimePage(Integer pageNum, Integer pageSize);
    /**
     * 修改物流订单备注
     */
    Integer updateLogisticsOrderRemark(LogisticsOrderDto param);

    /**
     * 查询客服跟单接口
     */
    PagenationDto<LogisticsOrderDto> queryServiceLogisticsOrder(QueryLogisticsOrderDto entity, Integer pageNum, Integer pageSize);
}
