package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BannerDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.BannerService;
import com.qiho.center.common.dao.QihoBannerDAO;
import com.qiho.center.common.entity.item.QihoBannerEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2017-08-28 17:57
 **/
@Service
public class BannerServiceImpl implements BannerService{

    @Autowired
    private QihoBannerDAO qihoBannerDAO;

    @Override
    public BannerDto findById(Long id) {
        return BeanUtils.copy(qihoBannerDAO.findById(id),BannerDto.class);
    }

    @Override
    public List<BannerDto> findAllBanners() {
        List<QihoBannerEntity> list = qihoBannerDAO.findAllBanners();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return BeanUtils.copyList(list,BannerDto.class);
    }

    @Override
    public List<BannerDto> findValidBanners() {
        List<QihoBannerEntity> list = qihoBannerDAO.findValidBanners();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return BeanUtils.copyList(list,BannerDto.class);
    }

    @Override
    public int saveBanner(BannerDto dto) {
        QihoBannerEntity entity = BeanUtils.copy(dto,QihoBannerEntity.class);
        int result;
        if (dto.getId() == null){
            result = qihoBannerDAO.createBanner(entity);
        } else {
            result = qihoBannerDAO.updateBanner(entity);
        }
        return result;
    }

    @Override
    public int deleteBanner(Long id) {
        return qihoBannerDAO.deleteBanner(id);
    }

    @Override
    public int sortBanner(String idList) {
        List<Long> ids = Arrays.asList(idList.split(",")).stream().map(s -> Long.parseLong(s.trim())).
                collect(Collectors.toList());
        if (ids.size() != qihoBannerDAO.countBanner()){
            throw new QihoException("传入Id数与Banner数不一致");
        }
        List<QihoBannerEntity> entityList = qihoBannerDAO.findAllBanners();
        int update = 0;
        int index = 0;
        for (Long id : ids){
            entityList.get(index).setId(id);
            entityList.get(index).setPayload(ids.size()-index);
            update += qihoBannerDAO.updatePayload(entityList.get(index));
            index++;
        }
        return update;
    }

    @Override
    public int countBanner() {
        return qihoBannerDAO.countBanner();
    }

    @Override
    public int findMaxPayload() {
        Integer maxPayload = qihoBannerDAO.findMaxPayload();
        if (null == maxPayload){
            return 0;
        }
        return maxPayload;
    }


}
