package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaWhiteListDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MediaWhiteListQueryParam;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.biz.service.order.ChannelInfoService;
import com.qiho.center.common.dao.QihoMediaWhiteListDAO;
import com.qiho.center.common.entity.campaign.QihoMediaWhiteListEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by qianjue on 2017/9/8.
 */
@Service
public class MediaWhiteListServiceImpl implements MediaWhiteListService {

	@Resource
	private QihoMediaWhiteListDAO qihoMediaWhiteListDAO;

	@Resource
	private ChannelInfoService    channelInfoService;

	@Override
	public Long saveOrUpdateWhiteList(MediaWhiteListDto whiteListDto) {
		QihoMediaWhiteListEntity entity = BeanUtils.copy(whiteListDto,QihoMediaWhiteListEntity.class);
		entity.setIsDeleted(0);
		//验证appId是否存在
		MediaWhiteListQueryParam param = new MediaWhiteListQueryParam();
		param.setAppId(entity.getAppId());
		QihoMediaWhiteListEntity resultEntity = qihoMediaWhiteListDAO.selectWhiteListByParam(param);
		if(null!=resultEntity && !resultEntity.getId().equals(entity.getId())){
			throw new QihoException("媒体AppId已存在");
		}
		//验证媒体名称是否已经存在
		param.setAppId(null);
		param.setAppName(entity.getAppName());
		resultEntity = qihoMediaWhiteListDAO.selectWhiteListByParam(param);
		if(null != resultEntity && ! resultEntity.getId().equals(entity.getId())){
			throw new QihoException("媒体名称已存在");
		}
		if(null==entity.getId()){
			qihoMediaWhiteListDAO.insert(entity);
		}else{
			qihoMediaWhiteListDAO.update(entity);
		}
		return entity.getId();
	}


	@Override
	public Integer deleteWhiteListById(Long id) {
		return qihoMediaWhiteListDAO.delete(id);
	}

	@Override
	public PagenationDto<MediaWhiteListDto> queryWhiteListPage(MediaWhiteListQueryParam param) {
		PagenationDto<MediaWhiteListDto> page = new PagenationDto<>();
		int count = qihoMediaWhiteListDAO.selectWhiteListPageCount(param);
		page.setTotal(count);
		if(count ==0){
			page.setList(Lists.newArrayList());
			return page;
		}
		List<QihoMediaWhiteListEntity> list = qihoMediaWhiteListDAO.selectWhiteListByPage(param);
		page.setList(BeanUtils.copyList(list,MediaWhiteListDto.class));
		return page;
	}

	@Override
	public QihoMediaWhiteListEntity queryWhiteListByParam(MediaWhiteListQueryParam param) {
		return qihoMediaWhiteListDAO.selectWhiteListByParam(param);
	}


	@Override
	public boolean isInWhiteList(String orderId) {
		ChannelInfoDto infoDto = channelInfoService.findByOrderId(orderId);
		if(null==infoDto || null ==infoDto.getAppId()){
			return Boolean.FALSE;
		}
		//
		MediaWhiteListQueryParam param = new MediaWhiteListQueryParam();
		param.setAppId(infoDto.getAppId());
		QihoMediaWhiteListEntity entity = qihoMediaWhiteListDAO.selectWhiteListByParam(param);
		return null != entity;
	}

	@Override
	public QihoMediaWhiteListEntity selectWhiteById(Long id) {
		return qihoMediaWhiteListDAO.selectById(id);
	}
}
