package com.qiho.center.biz.service.impl;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.params.QuerySkinParams;
import com.qiho.center.biz.service.SkinService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoSkinDAO;
import com.qiho.center.common.entity.QihoSkinEntity;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Date:     2017/7/5 11:12 <br/>
 *
 * @author huika
 * @see
 */
@Service
public class SkinServiceImpl implements SkinService {
    @Autowired
    private QihoSkinDAO skinDAO;

    @Override
    public PagenationDto<SkinDto> queryAllSkin(QuerySkinParams params) {
        List<SkinDto> skinDtoList = Lists.transform(skinDAO.queryAllSkin(params), this::convertDto);
        Integer count = skinDAO.countAllSkin(params);
        PagenationDto<SkinDto> pagenationDto = new PagenationDto<>();
        pagenationDto.setList(skinDtoList);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    @Override
    public SkinDto querySkinById(Long id) {
        return convertDto(skinDAO.querySkinById(id));
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Long createSkin(SkinDto entity) {
        return skinDAO.createSkin(convertEntity(entity));
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public int updateSkin(SkinDto entity) {
        return skinDAO.updateSkin(convertEntity(entity));
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public int deleteSkin(Long id) {
        return skinDAO.deleteSkin(id);
    }

    private SkinDto convertDto(QihoSkinEntity entity) {
        if (entity == null) {
            return null;
        }
        SkinDto skinDto = new SkinDto();
        BeanUtils.copyProperties(entity, skinDto);
        skinDto.setGmtModified(entity.getGmtModified().getTime());
        return skinDto;
    }

    private QihoSkinEntity convertEntity(SkinDto dto) {
        if (dto == null) {
            return null;
        }
        QihoSkinEntity entity = new QihoSkinEntity();
        BeanUtils.copyProperties(dto, entity);
        return entity;
    }
}
