package com.qiho.center.biz.service.impl.homepage;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.homepage.TabItemService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoTabItemDAO;
import com.qiho.center.common.entity.homepage.QihoTabItemEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/8/29.
 */
@Service
public class TabItemServiceImpl implements TabItemService{

	@Resource
	private QihoTabItemDAO   qihoTabItemDAO;

	@Resource
	private ItemService itemService;

	@Resource
	private OrderSnapshotService orderSnapshotService;

	@Resource
	private ItemSaleCountService itemSaleCountService;

	@Override
	public Integer saveTabItemList(List<TabItemParams> list) {
		if(CollectionUtils.isEmpty(list)){
			return  0;
		}
		List<QihoTabItemEntity> entityList = Lists.newArrayList();
		list.stream().forEach(param -> {
			//根据tabId和itemId查询一下是否已经存在有效记录
			QihoTabItemEntity entity = qihoTabItemDAO.queryTabItemByTabIdAndItemId(param.getTabId(),param.getItemId());
			if(null==entity){
				entity = new QihoTabItemEntity();
				entity.setItemId(param.getItemId());
				entity.setTabId(param.getTabId());
				entity.setDeleted(0);
				entity.setTopPayload(0L);
				entity.setRecentlySaleNum(queryRecentThreeDaysSaleNum(entity.getItemId()));
				entityList.add(entity);
			}
		});
		if(CollectionUtils.isEmpty(entityList)){
			return 0;
		}
		return qihoTabItemDAO.batchInsertQihoTabItem(entityList);
	}


	private Integer queryRecentThreeDaysSaleNum(Long itemId) {
		Date startTime = DateUtils.getStartTime(DateUtils.daysAddOrSub(new Date(),-3));
		Date endTime = DateUtils.getStartTime(new Date());
		return  orderSnapshotService.queryItemSaleCount(itemId,startTime,endTime);
	}

	@Override
	public Integer deleteTabItemByIdList(List<Long> idList) {
		if(CollectionUtils.isEmpty(idList)){
			return 0;
		}
		return  qihoTabItemDAO.deleteQihoTabItem(idList);
	}


	@Transactional(DsConstants.DATABASE_QIHO)
	@Override
	public Integer updateTabItemTopPayloadByList(List<Long> idList, Boolean top) {
		if(CollectionUtils.isEmpty(idList)){
			return 0;
		}
		Long maxValue = null;
		if(top){
			  Long max = qihoTabItemDAO.selectMaxPayload();
			  maxValue = null == max ? idList.size() : max + idList.size();
		}
		for(Long id : idList){
			QihoTabItemEntity entity = new QihoTabItemEntity();
			entity.setId(id);
			entity.setTopPayload(top ? maxValue : 0);
			qihoTabItemDAO.updateTabItemTopPayload(entity);
			if(top){
				maxValue --;
			}
		}
		return idList.size();
	}


	@Override
	public List<TabItemDto> findTabItemList(TabItemQueryParam params) {
		List<QihoTabItemEntity> list = qihoTabItemDAO.findQihoTabItemList(params);
		if(CollectionUtils.isEmpty(list)){
			return Lists.newArrayList();
		}
		Map<Long,QihoTabItemEntity> map = Maps.newLinkedHashMap();
		for(QihoTabItemEntity it:list){
			map.put(it.getItemId(),it);
		}
		List<ItemDto> dtoList = itemService.findItemDtoByItemIds(map.keySet());
		Map<Long,ItemDto> itemDtoMap = Maps.newHashMap();
		dtoList.stream().forEach(dto -> itemDtoMap.put(dto.getId(),dto));
		return converToResult(list,itemDtoMap);
	}

	private List<TabItemDto> converToResult(List<QihoTabItemEntity> list, Map<Long, ItemDto> itemDtoMap) {
		List<TabItemDto> resultList = Lists.newArrayList();
		for(QihoTabItemEntity entity:list){
			TabItemDto dto = new TabItemDto();
			dto.setId(entity.getId());
			dto.setItemId(entity.getItemId());
			dto.setTabId(entity.getTabId());
			dto.setRecentlySaleNum(entity.getRecentlySaleNum());
			dto.setTopPayload(entity.getTopPayload());
			ItemDto itemDto = itemDtoMap.get(entity.getItemId());
			if(null==itemDto){
				continue;
			}
			dto.setItemNo(itemDto.getItemNo());
			dto.setImage(itemDto.getExtParamValue("image"));
			dto.setItemName(itemDto.getItemName());
			dto.setItemShortName(itemDto.getItemShortName());
			dto.setMinPrice(itemDto.getMinPrice());
			dto.setStock(itemDto.getStock());
			dto.setItemStatus(itemDto.getItemStatus());
			resultList.add(dto);
		}
		return  resultList;
	}

	@Override
	public List<ItemDto> queryTabItemIndex(TabItemQueryParam params) {
		List<QihoTabItemEntity> list = qihoTabItemDAO.findQihoTabItemList(params);
		if(CollectionUtils.isEmpty(list)){
			return Lists.newArrayList();
		}
		Map<Long,QihoTabItemEntity> map = Maps.newLinkedHashMap();
		List<Long> itemList = Lists.newArrayList();
		for(QihoTabItemEntity it:list){
			map.put(it.getItemId(),it);
			itemList.add(it.getItemId());
		}
		List<ItemDto> dtoList = itemService.findItemDtoByItemIds(map.keySet());
		Map<Long,Integer> saleMap = itemSaleCountService.queryItemSaleNum(itemList);
		List<ItemDto> resultList = Lists.newArrayList();
		Map<Long,ItemDto> resultMap = Maps.newHashMap();
		for(ItemDto item:dtoList){
			//如果商品下架或者库存为0,则剔除掉
			if(StringUtils.equals("OFF",item.getItemStatus())
					|| item.getStock().intValue() <= 0){
				continue;
			}
			//设置一下库存
			item.setSaleNum(null== saleMap.get(item.getId()) ? 0 :saleMap.get(item.getId()));
			resultMap.put(item.getId(),item);
		}
		//进行重新排序
		map.entrySet().forEach(e ->{
			if(null!=resultMap.get(e.getKey())){
				resultList.add(resultMap.get(e.getKey()));
			}
		});
		return resultList;
	}

	@Override
	public List<QihoTabItemEntity> queryAllItemListByPage(int offSet, int pageSize) {
		return  qihoTabItemDAO.queryAllItemListByPage(offSet,pageSize);
	}


	@Override
	public Integer updateTabItem(QihoTabItemEntity enitiy) {
		return qihoTabItemDAO.updateTabItem(enitiy);
	}
}
