/**
 * Project Name:qiho-center-biz File Name:ErpOrderServiceImpl.java Package Name:com.qiho.center.biz.service.impl.order
 * Date:2017年6月6日下午12:00:28 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * ClassName:ErpOrderServiceImpl <br/>
 * ERP订单服务实现类. <br/>
 * Date: 2017年6月6日 下午12:00:28 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class ErpOrderServiceImpl implements ErpOrderService {

    @Autowired
    private QihoErpOrderDAO   qihoErpOrderDAO;
    @Autowired
    private SequenceNoBuilder builder;

    @Autowired
    private OrderStockService orderStockService;


    @Override
    public List<ErpOrderDto> findByOrderId(String orderId) {
        List<QihoErpOrderEntity> list = qihoErpOrderDAO.findByOrderId(orderId);
        return BeanUtils.copyList(list, ErpOrderDto.class);
    }

    @Override
    public PagenationDto<ErpOrderDto> findErpOrderPage(ErpOrderPageParams params) {
        List<QihoErpOrderEntity> list = qihoErpOrderDAO.findErpOrderPage(params);
        int total = qihoErpOrderDAO.findErpOrderPageCount(params);

        PagenationDto<ErpOrderDto> page = new PagenationDto<>();
        page.setTotal(total);
        page.setList(BeanUtils.copyList(list, ErpOrderDto.class));
        return page;
    }

    @Override
    public ErpOrderDto createErpOrder(QihoErpOrderEntity order) {
        order.setErpId(builder.createSeqNo(SeqBizTypeEnum.ERP, order.getItemId()));
        order.setErpStatus(ErpStatusEnum.TO_NOTIFY.getCode());

        qihoErpOrderDAO.createErpOrder(order);
        ErpOrderDto dto = new ErpOrderDto();
        BeanUtils.copy(order, dto);
        return dto;
    }

    @Override
    public ErpOrderDto findErpOrderByErpId(String erpId) {
        QihoErpOrderEntity entity = qihoErpOrderDAO.findByErpId(erpId);
        if (entity == null) {
            return null;
        }
        ErpOrderDto dto = new ErpOrderDto();
        BeanUtils.copy(entity, dto);
        return dto;
    }

    @Override
    public ErpOrderDto updateErpStatus(String erpId, ErpStatusEnum erpStatus, ErpStatusEnum beforeErpStatus,
                                       String failedMessage) {
        QihoErpOrderEntity entity = qihoErpOrderDAO.findByErpId(erpId);
        if (entity == null || erpStatus == null) {
            throw new QihoException("ERP订单不存在,或订单状态为空");
        }
        String beforeStatus = null;
        if(beforeErpStatus != null){
            beforeStatus = beforeErpStatus.getCode();
        }
        int ret = qihoErpOrderDAO.updateErpStatus(erpId, erpStatus.getCode(), failedMessage, beforeStatus);
        if (ret != 1) {
            throw new QihoException("ERP订单更新订单状态异常");
        }
        if(erpStatus.equals(ErpStatusEnum.FAILED)){
            orderStockService.returnSkuStockByOrderId(entity.getOrderId());
        }
        return findErpOrderByErpId(erpId);
    }

    /**
     * @see com.qiho.center.biz.service.order.ErpOrderService#updateErpId(java.lang.Long, java.lang.String)
     */
    @Override
    public void updateErpId(Long id, String erpId) {
        qihoErpOrderDAO.updateErpId(id, erpId);
    }

}
