package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.model.ErpStock;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.daoh.qiho.QihoItemSkuMapper;
import com.qiho.center.common.daoh.qiho.QihoOrderItemInfoMapper;
import com.qiho.center.common.entityd.qiho.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.QihoOrderItemInfoEntity;
import com.qiho.center.common.util.AppLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by weny.cai on 2017/8/15.
 */
@Service
public class OrderStockServiceImpl implements OrderStockService {

    private static final Logger logger = LoggerFactory.getLogger(OrderStockServiceImpl.class);
    @Autowired
    private QihoOrderItemInfoMapper qihoOrderItemInfoMapper;

    @Autowired
    private RemoteStockBackendService remoteStockBackendService;

    @Autowired
    QihoItemSkuMapper qihoItemSkuMapper;

    @Autowired
    private RemoteStockService remoteStockService;

    /**
     * 返还订单的库存
     * @param orderId
     * @return
     */
    @Override
    public DubboResult<Boolean> returnSkuStockByOrderId(String orderId) {
        List<QihoOrderItemInfoEntity> list = qihoOrderItemInfoMapper.selectQihoOrderItemInfosByOrderId(orderId);
        List<UpdateStockReqDto> increateList = Lists.newArrayList();
        for (QihoOrderItemInfoEntity qihoOrderItemInfo : list) {
            UpdateStockReqDto reqDto = new UpdateStockReqDto();
            reqDto.setStockId(qihoOrderItemInfo.getStockId());
            reqDto.setStock(qihoOrderItemInfo.getQuantity());
            increateList.add(reqDto);
        }
        DubboResult<Boolean> result = remoteStockBackendService.increaseItemStockBatch(increateList);
        if(!result.isSuccess()){
            AppLogUtil.error(logger,"订单{}:库存返还失败!",orderId);
            throw new QihoException("库存返还失败!");
        }
        AppLogUtil.info(logger,"订单{}：返还库存成功!",orderId);
        return result;
    }

    /**
     * 旺店通库存同步
     * 处理库存数据
     */
    public void handlerErpStocks(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> descreaseStock, List<ErpStock> stocks) {
        List<String> paramSkuNo = toConvert(stocks);
        //批量查询
        List<QihoItemSkuEntity> qihoItemSkus = qihoItemSkuMapper.selectALLItemSku(paramSkuNo);
        if(!qihoItemSkus.isEmpty()) {
            Map<String,Map<String,BigDecimal>> erpQ = qihoItemSkuMapper.selectErpOrderQuantityBySkuNo(paramSkuNo);
            Map<String,Map<String,BigDecimal>> ordQ = qihoItemSkuMapper.selectOrderQuantityBySkuNo(paramSkuNo);
            List<Long> stockIds = toConvertStockIds(qihoItemSkus);
            DubboResult<List<StockDto>> stockDs = remoteStockService.findBatchByIds(stockIds);
            Map<String,QihoItemSkuEntity> qihoItemSkuMap = toConvertSkuMap(qihoItemSkus);
            Map<Long,StockDto> stockMaps = toConvertMap(stockDs);
            for (ErpStock stock : stocks) {
                QihoItemSkuEntity sku = qihoItemSkuMap.get(stock.getSpecNo());
                if(sku==null) continue;
                handlerErpStock(increaseStock, descreaseStock, erpQ, ordQ, stockMaps, stock, sku);
            }
        }
    }

    /**
     * 处理单品库存的逻辑
     * @param increaseStock
     * @param descreaseStock
     * @param erpQ
     * @param ordQ
     * @param stockMaps
     * @param stock
     * @param sku
     */
    private void handlerErpStock(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> descreaseStock, Map<String, Map<String, BigDecimal>> erpQ, Map<String, Map<String, BigDecimal>> ordQ, Map<Long, StockDto> stockMaps, ErpStock stock, QihoItemSkuEntity sku) {
        long erpNum = 0;
        long orderNum = 0;
        if(erpQ.get(stock.getSpecNo())!=null){
            erpNum = erpQ.get(stock.getSpecNo()).get("quantity").longValue();
        }
        if(ordQ.get(stock.getSpecNo())!=null){
            orderNum = ordQ.get(stock.getSpecNo()).get("quantity").longValue();
        }
        long quantity = erpNum + orderNum;
        long erpStock = (long)(stock.getStockNum()-stock.getOrderNum()-stock.getSendingNum());
        long totoleSkuNum = erpStock - quantity;
        long creaseNum = 0;
        long stockId = sku.getStockId();
        //如果订单库存超过了ERP实际库存  库存置为零防止继续超卖
        long remoteStock = stockMaps.get(stockId).getStock();
        if(totoleSkuNum>=0){
            creaseNum =  totoleSkuNum - remoteStock;
        }else{
            creaseNum =  creaseNum - remoteStock;
            logger.warn("库存{}出现超卖,请检查库存，库存已置为0",stockId);
        }
        if(creaseNum==0) return;
        UpdateStockReqDto updateStockReqDto = new UpdateStockReqDto();
        updateStockReqDto.setStockId(stockId);
        updateStockReqDto.setStock(Math.abs(creaseNum));
        if(creaseNum>0){
            increaseStock.add(updateStockReqDto);
        }else if(creaseNum<0){
            descreaseStock.add(updateStockReqDto);
        }
    }

    private Map<String,QihoItemSkuEntity> toConvertSkuMap(List<QihoItemSkuEntity> qihoItemSkus) {
        Map<String,QihoItemSkuEntity> result = new HashMap<>();
        for (QihoItemSkuEntity itemSkus : qihoItemSkus) {
            result.put(itemSkus.getSkuNo(),itemSkus);
        }
        return result;
    }

    private List<Long> toConvertStockIds(List<QihoItemSkuEntity> qihoItemSkus) {
        List<Long> result = new ArrayList<>();
        for (QihoItemSkuEntity itemSkus : qihoItemSkus) {
            result.add(itemSkus.getStockId());
        }
        return result;
    }

    private Map<Long,StockDto> toConvertMap(DubboResult<List<StockDto>> stockDs) {
        Map<Long,StockDto> result = new HashMap<>();
        List<StockDto> list = stockDs.getResult();
        for (StockDto stockDto : list) {
            result.put(stockDto.getStockID(),stockDto);
        }
        return result;
    }

    private List<String> toConvert(List<ErpStock> stocks) {
        List<String> result = new ArrayList<>();
        for (ErpStock stock : stocks) {
            result.add(String.valueOf(stock.getSpecNo()));
        }
        return result;
    }

}
