package com.qiho.center.biz.service.impl.tab;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.TabDto;
import com.qiho.center.biz.service.tab.TabService;
import com.qiho.center.common.daoh.qiho.QihoTabMapper;
import com.qiho.center.common.entityd.qiho.QihoTabEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by weny.cai on 2017/9/5.
 */
@Service
public class TabServiceImpl implements TabService {

    @Resource
    QihoTabMapper qihoTabMapper;

    @Override
    public int add(TabDto tabDto) {
        QihoTabEntity qihoTabEntity = BeanUtils.copy(tabDto,QihoTabEntity.class);
        qihoTabEntity.setStatus("1");
        int payload = qihoTabMapper.findMaxPlayload();
        qihoTabEntity.setPayload(payload+1);
        return qihoTabMapper.insert(qihoTabEntity);
    }

    @Override
    public int deleteList(List<Long> ids) {
        return qihoTabMapper.deleteByPrimaryKeys(ids);
    }

    @Override
    public int update(TabDto tabDto) {
        QihoTabEntity tabEntity = BeanUtils.copy(tabDto,QihoTabEntity.class);
        return qihoTabMapper.updateByPrimaryKeySelective(tabEntity);
    }

    @Override
    public TabDto queryDetail(Long id) {
        QihoTabEntity tabEntity = qihoTabMapper.selectByPrimaryKey(id);
        return BeanUtils.copy(tabEntity,TabDto.class);
    }

    @Override
    public PagenationDto<TabDto> queryList() {
        PagenationDto<TabDto> pagenation = new PagenationDto<>();
        List<QihoTabEntity> list = qihoTabMapper.queryList();
        if(!list.isEmpty()){//计算总销量
            pagenation.setList(convertToTabDto(list));
        }else{
            pagenation.setList(null);
        }
        return pagenation;
    }

    @Override
    public List<TabDto> queryOnList() {
        List<QihoTabEntity> list = qihoTabMapper.queryOnList();
        return convertToTabDto(list);
    }

    @Override
    public void sortByPayLoad(Long sortId, Integer startPayload, Integer endPayload) {
        if (Objects.equal(startPayload, endPayload)) {
            return;
        }
        int offset;
        Integer startParam;
        Integer endParam;
        if (startPayload > endPayload) {
            offset = 1;
            endParam = startPayload;
            startParam = endPayload;
        }else{
            endParam = endPayload;
            startParam = startPayload;
            offset = -1;
        }
        List<QihoTabEntity> list = qihoTabMapper.findListBetweenPayload(startParam,endParam);
        if (CollectionUtils.isNotEmpty(list)) {
            QihoTabEntity tab = new QihoTabEntity();
            tab.setId(sortId);
            tab.setPayload(endPayload);
            qihoTabMapper.updateByPrimaryKeySelective(tab);
            // 被移动的类目payload更新为endPayload
            List<Long> tabs = Lists.newArrayList();
            for (QihoTabEntity qihoTabEntity : list) {
                if (qihoTabEntity.getId() != sortId) {
                    tabs.add(qihoTabEntity.getId());
                }
            }
            qihoTabMapper.updateBatchByOffset(tabs, offset);
        }
    }

    private List<TabDto> convertToTabDto(List<QihoTabEntity> list) {
        List<TabDto> result = Lists.newArrayList();
        for (QihoTabEntity tabEntity : list) {
            TabDto tabDto = BeanUtils.copy(tabEntity,TabDto.class);
            result.add(tabDto);
        }
        return result;
    }
}
