/**
 * Project Name:qiho-center-biz
 * File Name:OrderService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年6月2日下午7:20:31
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;

/**
 * ClassName:OrderService <br/>
 * 订单服务. <br/>
 * Date:     2017年6月2日 下午7:20:31 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface OrderService {

    /**
     * 创建订单
     * @author zhanglihui
     * @param order       订单内容
     * @param channelInfo 订单渠道信息
     * @param payType     付款方式
     * @return 订单ID
     */
    String createOrder(OrderDto order, ChannelInfoDto channelInfo, String payType);

    /**
     * 审核订单
     * @param params
     */
    Boolean auditOrder(OrderAuditParams params);

    /**
     * 根据订单ID查询订单信息
     * @author zhanglihui
     * @param orderId
     * @return OrderDto
     */
    OrderDto findByOrderId(String orderId);

    /**
     * 更新订单商品信息
     * @author zhanglihui
     * @param param
     */
    void updateOrderItem(OrderItemParam param);

    /**
     * 更新订单买家信息
     * @author zhanglihui
     * @param param
     */
    void updateOrderConsumer(OrderConsumerParam param);

    /**
     * 将订单变成失败
     * @param orderId
     * @param remark
     * @param orderApprovalStatusEnum 审核状态
     */
    void rejectOrder(String orderId, String remark, OrderApprovalStatusEnum orderApprovalStatusEnum);

    /**
     * 更新主订单状态
     * @param orderId
     * @param orderStatus
     */
    void updateOrderStatus(String orderId, OrderStatusEnum orderStatus);
    
    
    
    boolean  closeOrder(String orderId,String remark,String fundId);
}

