/**
 * Project Name:qiho-center-biz
 * File Name:SmsService.java
 * Package Name:com.qiho.center.biz.service.order
 * Date:2017年6月3日下午12:02:19
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import com.qiho.center.api.params.YunPianPushParams;
import com.qiho.center.common.entity.QihoTemplateEntity;

import java.util.Map;

/**
 * ClassName:SmsService <br/>
 * 短信服务. <br/>
 * Date:     2017年6月3日 下午12:02:19 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface SmsService {

    /**
     * 发送短信验证码，用于下单校验
     * @author zhanglihui
     * @param mobile 手机号码
     * @param smsCode 验证码
     * @return 是否发送成功
     */
    boolean sendSmsCode(String mobile, String smsCode);

    /**
     * 发送短信
     * 需要参数渲染
     * @param entity 短信模板
     * @param entity 替换变量map
     * @param mobile 手机号码
     * @return 是否发送成功
     */
    boolean singleSend(QihoTemplateEntity entity, Map<String,String> context, String mobile);

    /**
     * 发送短信
     * PS:不需要变量渲染
     * @param entity 短信模板
     * @param mobile 手机号码
     * @return 是否发送成功
     */
    boolean singleSend(QihoTemplateEntity entity, String mobile);

    /**
     * 验证云片签名正确性:ture为验签通过
     */
    boolean checkSign(YunPianPushParams params);
}

