package com.qiho.center.biz.bo;

import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;
import com.qiho.center.biz.model.AckErpStock;
import com.qiho.center.biz.model.ErpStock;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.util.ERPClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by weny.cai on 2017/8/9.
 */
@Service
public class SyncStockBo {

    private static final Logger logger = LoggerFactory.getLogger(SyncStockBo.class);

    @Autowired
    private RemoteStockBackendService remoteStockBackendService;

    @Autowired
    private OrderStockService orderStockService;

    @Value("${qiho.erp.shop.no}")
    private String shopNo;

    private static final String limit = "100";

    @Value("${qiho.stock.change.query.url}")
    private String erpStockChangeQueryUrl;

    @Value("${qiho.stock.change.ack.url}")
    private String stockChangeAckUrl;


    /***
     * 旺店通同步功能
     * 每个{}进行同步一次
     * {}可配置
     */
    public void syncStock(){
        int curPageNo = 0;
        List<UpdateStockReqDto> increaseStock = Lists.newArrayList();
        List<UpdateStockReqDto> decreaseStock = Lists.newArrayList();
        while(true){
            Map<String, String> params = getParams();
            String result = ERPClientUtil.execute(erpStockChangeQueryUrl, params);
            logger.warn("库存同步,旺店通数据为:{}",result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            String code = jsonObject.getString("code" );
            if(ErpErrorCodeReturnEnum.SUCCESS.getCode().equals(code)){
                result = jsonObject.getString("stock_change_list" );
                List<ErpStock> stocks = JSONArray.parseArray(result,ErpStock.class);
                if(stocks.isEmpty()) break;
                orderStockService.handlerErpStocks(increaseStock, decreaseStock, stocks);
                ackStock(stocks);
            }
            curPageNo ++;
        }
        DubboResult<Boolean> incResult = remoteStockBackendService.increaseItemStockBatch(increaseStock);
        DubboResult<Boolean> desResult = remoteStockBackendService.decreaseItemStockBatch(decreaseStock);
        if(!incResult.isSuccess()||!desResult.isSuccess()){
            logger.warn("库存同步失败：{},{}",incResult.getMsg(),desResult.getMsg());
        }

        logger.warn("库存同步:共{}页数据，每页100条",curPageNo);
    }

    /**
     * 回写库存同步数据
     * @param stocks
     */
    private void ackStock(List<ErpStock> stocks) {
        Map<String,String> ackParam = new HashMap<>();
        List<AckErpStock> ackErpStock = BeanUtils.copyList(stocks,AckErpStock.class);
        ackParam.put("stock_sync_list",JSONObject.toJSON(ackErpStock).toString());
        try {
            ERPClientUtil.execute(stockChangeAckUrl,ackParam);
            Thread.sleep(2000l);
        } catch (Exception e) {
            logger.error("返回ERP系统同步库存信息处理结果，请求失败", e);
        }
    }


    /**
     * ERP查询库存参数
     * @return
     */
    private Map<String,String> getParams() {
        Map<String, String> params = Maps.newHashMap();
        params.put("limit",limit);
        params.put("shop_no",shopNo);
        return params;
    }

}
