package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyCheckResultDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.common.enums.InnerLogTypeEnum;
import com.qiho.center.common.log.InnerLog;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Created by qianjue on 2017/8/2.
 */
public class AheadPreventOrderEngine extends BaseOrderEngine implements BaseEngine<StrategyCheckResultDto>{


	private Logger logger = LoggerFactory.getLogger(AheadPreventOrderEngine.class);

	/**
	 * 校验链路入口类
	 * @param valuteData
	 * @return
	 */
	private BaseHandler baseHandler;

	@Override
	public StrategyCheckResultDto process(StrategyCheckResultDto result){

			if(null == result || null==result.getOrderSnapshotDto()) {
				return result;
			}
			result.setSuccess(true);
			try{
				//查询所有策略,循环校验
				List<OrderStrategyDto> orderStrategyDtos = getOrderStrategyList(StrategyType.AHEAD_PREVENT_ORDER);
				//查询校验策略,如果为空,直接返回
				if (CollectionUtils.isEmpty(orderStrategyDtos)){
					return result;
				}
				return checkStrategy(result,orderStrategyDtos);
				//循环执行校验策略
			}catch (Exception e){
				logger.error("策略过滤链路失败, data={}",result.toString(), e);
			}
			return result;
		}


	private StrategyCheckResultDto checkStrategy(StrategyCheckResultDto result,List<OrderStrategyDto> orderStrategyDtos) {
		for (OrderStrategyDto orderStrategyDto : orderStrategyDtos){
			Boolean flag = Boolean.TRUE;//用来标记返回值,falg决定后续对订单的处理
			ResultBase<List<StrategyRuleDto>> resultBase = validateorderStrategyDto(orderStrategyDto);
			if(!resultBase.hasSuccessValue()) {
				logger.warn(resultBase.getErrorMsg());
				continue;
			}
			List<StrategyRuleDto> strategyRuleDtos =resultBase.getValue();
			ProcessContext processContext = null;
			for (StrategyRuleDto strategyRuleDto : strategyRuleDtos){
				//真正校验执行
				try{
					processContext = ProcessFaceory.createProcessContext(result.getOrderSnapshotDto(),strategyRuleDto,orderStrategyDto);
					ResultBase<Boolean> checkResult = baseHandler.handleRequest(processContext);
					if (checkResult.hasSuccessValue()){
						flag = flag && checkResult.getValue();
					}else{
						flag = Boolean.FALSE;
						logger.warn("本条策略规则校验失败 msg={} strategyName={} ruleName={} fieldName={}",
								checkResult.getErrorMsg(),orderStrategyDto.getStrategyName(),strategyRuleDto.getRuleName(),strategyRuleDto.getFieldName());
						break;//跳出本策略的循环,其中一环错误,校验无意义
					}
				}catch(Exception e){
					throw new QihoException("策略执行异常",e);
				}
			}
			//校验发现一处错误即可以跳出整个校验逻辑,返回结果
			//目前下单前置校验只有在线支付这一种处理方式,因此默认返回接口,提示错误
			//后续如果出现其他处理的方式,则需要重新扩展处理
			if (flag){
				JSONObject logInfo = new JSONObject();
				logInfo.put("order", result.getOrderSnapshotDto());
				logInfo.put("rule", orderStrategyDto);
				InnerLog.log(InnerLogTypeEnum.SUBMIT_ORDER_RULE, logInfo);
				result.setSuccess(false);
				result.setShotOrderHandlerEnum(ShotOrderHandlerEnum.fromVal(orderStrategyDto.getHandlerName()));
				return result;
			}
		}
		return result;
	}

	public BaseHandler getBaseHandler() {
		return baseHandler;
	}

	public void setBaseHandler(BaseHandler baseHandler) {
		this.baseHandler = baseHandler;
	}
}
