package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.service.ItemSaleCountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * Created by qianjue on 2017/9/14.
 * 每日凌晨执行
 * 统计商品所有的销量统计,来源于订单快照表
 * 查询后的数据存储于redis
 */
@Component
public class ItemSaleNumCountJob extends AbstractQihoSimpleElasticJob{

	private Logger log =  LoggerFactory.getLogger(ItemSaleNumCountJob.class);

	@Resource
	private ItemSaleCountService itemSaleCountService;

	@Override
	protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {

		log.warn("ItemSaleNumCountJob execute start");
		itemSaleCountService.syncItemHistorySaleNum();
		log.warn("ItemSaleNumCountJob execute end");
	}
}
