package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.enums.ShotOrder.OrderProcessWayEnum;
import com.qiho.center.api.params.BatchOrderGainParams;
import com.qiho.center.api.params.OrderGainParams;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by danke on 2017/9/8.
 * 定时任务,用于查询已经超过一小时有效时间的短信捞单处理订单,改处理方式为人工捞单
 */
@Component
public class NoteGainProcessJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(NoteGainProcessJob.class);

    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.warn("NoteGainProcessJob 定时查询短信捞单   启动成功");
        OrderGainParams queryParams = new OrderGainParams();
        queryParams.setOrderProcessWayEnum(OrderProcessWayEnum.NOTE_GAIN);
        queryParams.setProcessTime(getBeforeOneHour());
        try{
            List<QihoOrderSnapshotEntity> orders = qihoOrderSnapshotDAO.queryOrderByProcessWayAndTime(queryParams);
            if (CollectionUtils.isEmpty(orders))
                return;
            List<String> orderIds = orders.stream().map(QihoOrderSnapshotEntity::<String>getOrderId).collect(Collectors.toList());
            BatchOrderGainParams updateParams = new BatchOrderGainParams();
            updateParams.setOrderIds(orderIds);
            updateParams.setOrderProcessWayEnum(OrderProcessWayEnum.MANUAL_GAIN);
            qihoOrderSnapshotDAO.batchUpdateOrderProcessWay(updateParams);
        }catch (Exception e){
            LOGGER.error("定时查询失效短信捞单订单失败 msg={}",e);
        }
    }

    /**
     * 获取现在之前的一小时的时间
     * @return
     */
    private Date getBeforeOneHour(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 1);
        return calendar.getTime();
    }
}
