/**
 * Project Name:qiho-center-biz
 * File Name:SequenceResetJob.java
 * Package Name:com.qiho.center.biz.job
 * Date:2017年7月31日下午6:45:22
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.job;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.common.support.SequenceNoBuilder;
import com.qiho.center.common.util.AppLogUtil;


/**
 * ClassName:SequenceResetJob <br/>
 * 序列号重置. <br/>
 * Date:     2017年7月31日 下午6:45:22 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Component
public class SequenceResetJob extends AbstractQihoSimpleElasticJob {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceResetJob.class);
    @Autowired
    private SequenceNoBuilder sequenceNoBuilder;
    
    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.warn(LOG, "################ 开始执行定时任务【SequenceResetJob】 ################");
        sequenceNoBuilder.resetSequence();
    }

}

