package com.qiho.center.biz.paychannel.pay;

import cn.com.duiba.boot.ext.autoconfigure.accesslog.MD5;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qiho.center.api.constant.WeChatConstant;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.util.StringRandUtil;
import com.qiho.center.api.util.WechatPayAppUtil;
import com.qiho.center.api.util.XmlTranformUtil;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.io.InputStream;
import java.security.*;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/8/14.
 */
public class WechatPayBaseProcessor extends PayChannelProcessor{

	private Logger logger = LoggerFactory.getLogger(WechatPayBaseProcessor.class);

	public static final String UTF_8 = "utf-8";

	@Override
	public boolean verify(Map<String, String> params) {
		String  sign = params.get("sign");
		return  StringUtils.equals(sign,sign(params, WechatPayAppUtil.getSecret()));
	}

	@Override
	public String payExecute(String orderId, Map<String, String> params) {
		return null;
	}

	@Override
	public void refund(String orderId, String fundId, Integer refundAmt) {
		try{
			FundOrderDto dto = fundOrderService.findByFundId(fundId);
			Map<String,String> dataMap = buildRefundParams(orderId,fundId,refundAmt);
			String paramstr = XmlTranformUtil.mapToXml(dataMap);
			//封装一下新的
			String httpResultStr = this.postData(WeChatConstant.Url.REFUND_URL,paramstr);
			Map<String,String> resultMap = XmlTranformUtil.xmlToMap(httpResultStr);
			//通信异常
			if(WeChatConstant.ResponseCode.FAIL.equals(resultMap.get(WeChatConstant.WechatKey.RETURN_CODE))){
				AppLogUtil.error(logger,"微信发起退款网络通信异常,orderId={},msg={}",orderId,resultMap.get(WeChatConstant.WechatKey.RETURN_MSG));
				return;
			}
			//通信正常,但是其他有错误
			if(WeChatConstant.ResponseCode.FAIL.equals(resultMap.get(WeChatConstant.WechatKey.RESULT_CODE))){
				AppLogUtil.error(logger,"微信发起退款请求失败,orderId={},msg={}",orderId,resultMap.get("err_code_des"));
				return;
			}
			//更新退款单的外部退款单号
			dto.setOutSeqNo(resultMap.get("refund_id"));
			fundOrderService.update(dto);
		}catch(Exception e){
			AppLogUtil.error(logger,"微信发起退款请求失败,orderId={}",orderId,e);
		}
	}

	@Override
	public RefundResult refundQuery(String orderId, String fundId) {
		RefundResult result = new RefundResult();
		try{
			Map<String,String> dataMap = buildQueryRefundParams(orderId,fundId);
			String paramstr = XmlTranformUtil.mapToXml(dataMap);
			String httpResultStr = HttpClientUtil.postData(WeChatConstant.Url.REFUND_QUERY_URL,paramstr);
			Map<String,String> resultMap = XmlTranformUtil.xmlToMap(httpResultStr);

			if(WeChatConstant.ResponseCode.FAIL.equals(resultMap.get(WeChatConstant.WechatKey.RETURN_CODE))
					||WeChatConstant.ResponseCode.FAIL.equals(resultMap.get(WeChatConstant.WechatKey.RESULT_CODE))){
				result.setIsSuccess(false);
				return result;
			}
			result.setIsSuccess(true);
			//目前只会有一笔退款单
			String refundStatus = resultMap.get("refund_status_0");
			//退款成功
			if(StringUtils.equals(WeChatConstant.ResponseCode.SUCCESS,refundStatus)){
				result.setRefundStatus(RefundResult.REFUND_STATUS_SUCCESS);
				//还在处理中
			}else if(StringUtils.equals(WeChatConstant.ResponseCode.PROCESSING,refundStatus)){
				result.setRefundStatus(RefundResult.REFUND_STATUS_PROCESSING);
				//退款失败
			}else if(StringUtils.equals(WeChatConstant.ResponseCode.REFUNDCLOSE,refundStatus)
					|| StringUtils.equals(WeChatConstant.ResponseCode.CHANGE,refundStatus)){
				result.setRefundStatus(RefundResult.REFUND_STATUS_FAIL);
			}
		}catch(Exception e){
			AppLogUtil.error(logger,"查询退款请求失败,orderId={},fundId={}",orderId,fundId,e);
		}
		return result;
	}

	@Override
	PayTypeEnum getPayType() {
		return null;
	}

	@Override
	public PayDto queryPayResult(String orderId) {
		PayDto payDto = new PayDto();
		payDto.setSuccess(false);
		try{
			Map<String,String> map = buildQueryPayParams(orderId);
			String paramstr = XmlTranformUtil.mapToXml(map);
			String httpResultStr = HttpClientUtil.postData(WeChatConstant.Url.PAY_QUERY_URL,paramstr);
			Map<String,String> resultMap = XmlTranformUtil.xmlToMap(httpResultStr);
			if(StringUtils.equals(WeChatConstant.ResponseCode.FAIL,resultMap.get(WeChatConstant.WechatKey.RETURN_CODE))){
				AppLogUtil.error(logger,"微信查询订单支付状态失败,orderId={},msg={}",orderId,resultMap.get(WeChatConstant.WechatKey.RETURN_MSG));
				return payDto;
			}
			if(StringUtils.equals(WeChatConstant.ResponseCode.FAIL,resultMap.get(WeChatConstant.WechatKey.RESULT_CODE))){
				AppLogUtil.error(logger,"微信查询订单支付状态失败,orderId={},msg={}",orderId,resultMap.get("err_code_des"));
				return payDto;
			}
			if (StringUtils.equals(WeChatConstant.ResponseCode.SUCCESS,resultMap.get("trade_state"))){
				payDto.setSuccess(true);
				payDto.setOutTradeNo(resultMap.get("transaction_id"));
				payDto.setPayAmt(Integer.valueOf(resultMap.get("cash_fee")));
				payDto.setPayerId(resultMap.get("openid"));
			}
		}catch(Exception e){
			AppLogUtil.error(logger,"微信查询订单支付状态异常,orderId={}",orderId,e);
		}
		return payDto;
	}

	protected  String  sign(Map<String,String> dataMap,String secret){

		List<String> keyList = new ArrayList<>(dataMap.keySet());
		Collections.sort(keyList);
		StringBuilder toMD5StringBuilder = new StringBuilder();
		for(String key : keyList){
			//过滤掉sign字段
			if(StringUtils.equals(key,"sign")){
				continue;
			}
			String value = dataMap.get(key);
			if(value != null && value.length()>0){
				toMD5StringBuilder.append(key+"="+ value+"&");
			}
		}
		toMD5StringBuilder.append("key=").append(secret);
		try {
			return MD5.md5(toMD5StringBuilder.toString()).toUpperCase();
		} catch (Exception e) {
			AppLogUtil.error(logger,"MD5加密异常",e);
		}
		return StringUtils.EMPTY;
	}

	private String postData(String refundUrl, String paramstr)
			throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException,
			UnrecoverableKeyException {
		//读取微信提供的sll安全证书,证书有效期为20170728 - 20180728
		KeyStore keyStore = KeyStore.getInstance("PKCS12");
		InputStream instream = this.getClass().getResourceAsStream("/apiclient_cert.p12");
		try {
			keyStore.load(instream, WechatPayAppUtil.getMchId().toCharArray());
		} finally {
			instream.close();
		}
		SSLContext sslcontext = null;
		try {
			sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, WechatPayAppUtil.getMchId().toCharArray()).build();
		} catch (KeyManagementException e) {
			AppLogUtil.info(logger,"加载ssl证书异常",e);
		}
		// Allow TLSv1 protocol only
		SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[] { "TLSv1" }, null,
				SSLConnectionSocketFactory.getDefaultHostnameVerifier());
		CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
		HttpPost httpPost = new HttpPost(refundUrl);
		StringEntity strEntity = new StringEntity(paramstr,UTF_8 );
		strEntity.setContentEncoding(UTF_8);
		httpPost.setEntity(strEntity);
		HttpResponse response = httpclient.execute(httpPost);
		HttpEntity entity = response.getEntity();
		return EntityUtils.toString(entity, UTF_8).trim();
	}

	private Map<String,String> buildRefundParams(String orderId, String fundId, Integer refundAmt) {
		Map<String,String> dataMap = Maps.newHashMap();
		dataMap.put(WeChatConstant.WechatKey.APP_ID,WechatPayAppUtil.getAppId());
		dataMap.put(WeChatConstant.WechatKey.MCH_ID,WechatPayAppUtil.getMchId());
		dataMap.put(WeChatConstant.WechatKey.NONCE_STR, StringRandUtil.getRandomString(32));
		dataMap.put(WeChatConstant.WechatKey.OUT_TRADE_NO,orderId);
		dataMap.put(WeChatConstant.WechatKey.OUT_REFUND_NO,fundId);
		dataMap.put(WeChatConstant.WechatKey.TOTAL_FEE,refundAmt.toString());
		dataMap.put(WeChatConstant.WechatKey.REFUND_FEE,refundAmt.toString());
		dataMap.put(WeChatConstant.WechatKey.SIGN,sign(dataMap,WechatPayAppUtil.getSecret()));
		return dataMap;
	}

	private Map<String,String> buildQueryRefundParams(String orderId, String fundId) {
		Map<String,String> dataMap = Maps.newHashMap();
		dataMap.put(WeChatConstant.WechatKey.APP_ID,WechatPayAppUtil.getAppId());
		dataMap.put(WeChatConstant.WechatKey.MCH_ID,WechatPayAppUtil.getMchId());
		dataMap.put(WeChatConstant.WechatKey.NONCE_STR, StringRandUtil.getRandomString(32));
		dataMap.put(WeChatConstant.WechatKey.OUT_REFUND_NO,fundId);
		dataMap.put(WeChatConstant.WechatKey.OUT_TRADE_NO,orderId);
		dataMap.put(WeChatConstant.WechatKey.SIGN,sign(dataMap,WechatPayAppUtil.getSecret()));
		return dataMap;
	}

	private Map<String,String> buildQueryPayParams(String orderId) {
		Map<String,String> dataMap = Maps.newHashMap();
		dataMap.put(WeChatConstant.WechatKey.APP_ID,WechatPayAppUtil.getAppId());
		dataMap.put(WeChatConstant.WechatKey.MCH_ID,WechatPayAppUtil.getMchId());
		dataMap.put(WeChatConstant.WechatKey.OUT_TRADE_NO,orderId);
		dataMap.put(WeChatConstant.WechatKey.NONCE_STR,StringRandUtil.getRandomString(32));
		dataMap.put(WeChatConstant.WechatKey.SIGN,sign(dataMap,WechatPayAppUtil.getSecret()));
		return dataMap;
	}

	@Override
	public String getOpenIdByCode(String code) {
		String url = WeChatConstant.Url.AUTH_URL
				+"?appid="+WechatPayAppUtil.getAppId()
				+"&secret="+WechatPayAppUtil.getAppSecret()
				+"&code="+code+"&grant_type=authorization_code";
		String resultStr =  HttpClientUtil.sendGet(url);
		Map<String,String> map = (Map) JSONObject.parse(resultStr);
		String openId = map.get("openid");
		//如果没有返回openId,打印日志
		if(StringUtils.isBlank(openId)){
			AppLogUtil.warn(logger,"获取用户openId失败,code = {} ,返回报文 = {}",code,resultStr);
		}
		return openId;
	}

	@Override
	public void transAccount(String account, String fundId, Integer amount) {
		throw new QihoException("微信支付暂不支持转账");
	}


}
