package com.qiho.center.biz.process.note;

import com.qiho.center.common.entity.QihoTemplateEntity;

import java.util.Map;

/**
 * Created by danke on 2017/9/20.
 * 短信发送执行器,所有接入的短信渠道具体执行都要继承这个接口
 */
public interface SmsProcess {

    /**
     * 短信发送接口
     * 变量替换参数需业务方处理
     * @param template
     * @param param
     * @param mobile
     * @return
     */
    boolean smsSendByParam(QihoTemplateEntity template, Map<String,String> param, String mobile);

    /**
     * 短信发送接口
     * 适用于无参数变量替换
     * @param template
     * @param mobile
     * @return
     */
    boolean smsSend(QihoTemplateEntity template,String mobile);

}
