package com.qiho.center.biz.process.note;

import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.exception.QihoException;
import org.springframework.stereotype.Component;

import java.util.EnumMap;

/**
 * Created by danke on 2017/9/20.
 * 短信处理器管理工厂,不同渠道的短信处理器,均注册在这里
 */
@Component
public class SmsProcessFactory {

    /** 发送短信处理器MAP */
    private static EnumMap<SmsTypeEnum, SmsProcess> smsProcessMap = new EnumMap<>(SmsTypeEnum.class);

    /**
     * 获取对应的短信处理器
     * @param SmsType
     * @return
     */
    public SmsProcess decidePayChannel(SmsTypeEnum smsType) {
        return smsProcessMap.get(smsType);
    }

    /**
     * 注册处理器
     * @param smsType
     * @param smsProcess
     */
    public static void registPaychannel(SmsTypeEnum smsType, SmsProcess smsProcess) {
        if (smsType == null || smsProcess == null) {
            throw new QihoException("registSmsProcess 时参数出现null");
        }
        smsProcessMap.put(smsType, smsProcess);
    }
}
