/**
 * Project Name:qiho-center-biz File Name:RemoteItemServiceImpl.java Package Name:com.qiho.center.biz.remoteservice.impl
 * Date:2017年5月18日上午10:08:52 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.remoteservice.impl;

import java.util.List;

import com.qiho.center.api.dto.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.remoteservice.RemoteItemService;
import com.qiho.center.biz.service.ItemRecommendService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.SkuPropertyService;
import org.springframework.web.bind.annotation.RestController;

/**
 * ClassName:RemoteItemServiceImpl <br/>
 * Date: 2017年5月18日 上午10:08:52 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@RestController
public class RemoteItemServiceImpl implements RemoteItemService {

    private static final Logger  LOG = LoggerFactory.getLogger(RemoteItemServiceImpl.class);
    @Autowired
    private ItemService          itemService;
    @Autowired
    private ItemRecommendService itemRecommendService;
    @Autowired
    private SkuPropertyService   skuPropertyService;

    @Override
    public DubboResult<PagenationDto<ItemDto>> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize) {
        try {
            PagenationDto<ItemDto> page = itemService.queryItemPage(queryItem, pageNum, pageSize);
            return DubboResult.successResult(page);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemService.queryItemPage failed, queryItem={}, pageNum={}, pageSize={}",
                      queryItem, pageNum, pageSize, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemService#createItem(com.qiho.center.api.dto.ItemDetailDto)
     */
    @Override
    public DubboResult<Long> createItem(ItemDetailDto itemDetail) {
        try {
            Long itemId = itemService.createItem(itemDetail);
            return DubboResult.successResult(itemId);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemService.createItem failed, itemDetail={}", itemDetail, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemService#updateItem(com.qiho.center.api.dto.ItemDetailDto)
     */
    @Override
    public DubboResult<Void> updateItem(ItemDetailDto itemDetail) {
        try {
            itemService.updateItem(itemDetail);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemService.updateItem failed, itemDetail={}", itemDetail, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemService#queryItemDetail(java.lang.Long)
     */
    @Override
    public DubboResult<ItemDetailDto> queryItemDetail(Long itemId) {
        try {
            ItemDetailDto itemDetailDto = itemService.queryItemDetail(itemId);
            return DubboResult.successResult(itemDetailDto);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemService.queryItemDetail failed, itemId={}", itemId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemService#updateStatus(java.util.List, java.lang.String)
     */
    @Override
    public DubboResult<Void> updateStatus(List<Long> itemIds, String status) {
        try {
            itemService.updateStatus(itemIds, status);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemService.updateStatus failed, itemIds={}, status={}", itemIds, status, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemService#deleteBatch(java.util.List)
     */
    @Override
    public DubboResult<Void> deleteBatch(List<Long> itemIds) {
        try {
            itemService.deleteBatch(itemIds);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemService.deleteBatch failed, itemIds={}", itemIds, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemService#queryItemSimpleDto(java.lang.Long)
     */
    @Override
    public DubboResult<ItemSimpleDto> queryItemSimpleDto(Long itemId) {
        try {
            ItemSimpleDto dto = itemService.queryItemSimpleDto(itemId);
            return DubboResult.successResult(dto);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemService.queryItemSimpleDto failed, itemId={}", itemId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ItemSimpleDto>> queryItemSimpleList(ItemDto queryItem) {
        try{
            return DubboResult.successResult(itemService.queryItemSimpleList(queryItem));
        }catch(Exception e){
            LOG.error("RemoteItemServiceImpl call queryItemSimpleList error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateExtParamByItemId(ItemAdvertDto dto) {
        try{
            itemService.updateExtParamByItemId(dto);
            return DubboResult.successResult(Boolean.TRUE);
        }catch (Exception e){
            LOG.error("RemoteItemServiceImpl call updateExtParamByItemId error msg={}",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ItemAdvertDto> queryExtParamByItemId(Long itemId) {
        try{
            return DubboResult.successResult(itemService.queryExtParamByItemId(itemId));
        }catch (Exception e){
            LOG.error("RemoteItemServiceImpl call queryExtParamByItemId error msg={}",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public Long queryItemStockByItemId(Long itemId) {
        return itemService.queryItemStockByItemId(itemId);
    }

    @Override
    public Long updateVirtailStock(Long itemId) {
        return itemService.updateVirtailStock(itemId);
    }
}
