package com.qiho.center.biz.remoteservice.impl;

import java.util.List;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.google.common.collect.Sets;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.remoteservice.RemoteRecommendItemService;
import com.qiho.center.biz.bo.ItemRecommendBo;
import com.qiho.center.biz.service.ItemRecommendService;
import com.qiho.center.biz.service.ItemService;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by liuyao on 2017/5/23.
 */
@RestController
public class RemoteRecommendItemServiceImpl implements RemoteRecommendItemService {

    private Logger               logger = LoggerFactory.getLogger(RemoteRecommendItemServiceImpl.class);

    @Autowired
    private ItemRecommendService itemRecommendService;
    @Autowired
    private ItemRecommendBo      itemRecommendBo;
    @Autowired
    private ItemService          itemService;

    @Override
    public DubboResult<Void> recommendBatch(List<Long> itemIds) {
        try {
            itemRecommendService.recommendBatch(itemIds);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            logger.error("invoke RemoteItemService.recommendBatch failed, itemIds={}", itemIds, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ItemDto>> findRecommendItemList() {
        return DubboResult.successResult(itemRecommendBo.findRecommendItemList());
    }

    @Override
    public DubboResult<Boolean> deleteItemRecommend(Long itemId) {
        Set<Long> idset = Sets.newHashSet();
        idset.add(itemId);
        itemRecommendService.deleteItemRecommend(idset);
        return DubboResult.successResult(true);
    }

    @Override
    public DubboResult<Integer> sortItemRecommend(List<Long> itemIds) {
        return DubboResult.successResult(itemRecommendService.sortItemRecommend(itemIds));
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteRecommendItemService#findRecommendIndex()
     */
    @Override
    public DubboResult<List<ItemDto>> findRecommendIndex() {
        try {
            List<ItemDto> list = itemService.findRecommendIndex();
            return DubboResult.successResult(list);
        } catch (Exception e) {
            logger.error("invoke RemoteRecommendItemService.findRecommendIndex failed", e);
            return DubboResult.failResult(e.getMessage());
        }

    }
}
