package com.qiho.center.biz.remoteservice.impl.blackList;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.blackList.BlackListDto;
import com.qiho.center.api.dto.blackList.BlacklistCheckDto;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.BlackListCheckParams;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.api.params.BlackStrategyParams;
import com.qiho.center.api.remoteservice.blackList.RemoteBlackListService;
import com.qiho.center.biz.bo.BlackListBo;
import com.qiho.center.biz.service.BlackListService;
import com.qiho.center.biz.service.order.OrderStrategyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * ClassName: RemoteBlackListServiceImpl <br/>
 * Function: 黑名单dubbo服务. <br/>
 * date: 2017年6月22日 上午10:56:15 <br/>
 *
 * @author chencheng
 * @version
 */
@RestController
public class RemoteBlackListServiceImpl implements RemoteBlackListService {

    private Logger               logger = LoggerFactory.getLogger(RemoteBlackListServiceImpl.class);

    @Autowired
    private BlackListService     blackListService;

    @Autowired
    private OrderStrategyService orderStrategyService;

    @Autowired
    private BlackListBo          blackListBo;


    @Override
    public DubboResult<Integer> findBlackListCount(BlackListParams params) {
        try {
            return DubboResult.successResult(blackListService.findBlackListCount(params));
        } catch (Exception e) {
            logger.error("invoke RemoteBlackListService.findBlackListCount failed, params={}", params.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<PagenationDto<BlackListDto>> queryBlackListPage(BlackListParams params) {
        try {
            return DubboResult.successResult(blackListService.queryBlackListPage(params));
        } catch (Exception e) {
            logger.error("invoke RemoteBlackListService.queryBlackListPage failed, params={}", params.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> batchBlackList(String progressKey, List<BlackListOperationParams> paramList) {
        try {
            return DubboResult.successResult(blackListBo.batchBlackList(progressKey, paramList));
        } catch (Exception e) {
            logger.error("invoke RemoteLogisticsOrderService.batchBlackList failed, progressKey={}, paramList={}",
                      progressKey, paramList, e);
            return DubboResult.failResult(e.getMessage());
        }
    }



    @Override
    public DubboResult<Boolean> delete(Long id, QueryBlackListTypeEnum type) {
        try {
            return DubboResult.successResult(blackListService.deleteById(id, type));
        } catch (Exception e) {
            logger.error("invoke RemoteBlackListService.batchBlackList failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateBlackStrategy(BlackStrategyParams blackStrategyParams) {
        try {
            OrderStrategyDto orderStrategyDto = orderStrategyService.findStrategyById(blackStrategyParams.getId());
            orderStrategyDto.setUpdator(blackStrategyParams.getUpdator());
            orderStrategyDto.setRulevalue(JSONObject.toJSONString(blackStrategyParams));
            return DubboResult.successResult(orderStrategyService.updateStrategy(orderStrategyDto));
        } catch (Exception e) {
            logger.error("invoke RemoteBlackListService.updateBlackStrategy failed, blackStrategyParams={}",
                      blackStrategyParams.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<BlacklistCheckDto> blackListCheck(BlackListCheckParams params) {
        try {
            BlacklistCheckDto dto = blackListService.blacklistCheck(params);
            return DubboResult.successResult(dto);
        } catch (Exception e) {
            logger.error("invoke RemoteBlackListService.blackListCheck failed, params={}",
                      params, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<OrderStrategyDto> findBlackStrategy(StrategyType strategyType) {
        try {
            return DubboResult.successResult(orderStrategyService.findStrategyByStrategyType(strategyType));
        } catch (Exception e) {
            logger.error("invoke RemoteBlackListService.updateBlackStrategy failed, strategyType={}",
                      strategyType.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }


}
