package com.qiho.center.biz.remoteservice.impl.order;

import com.qiho.center.api.dto.AfterSaleOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.AfterSaleQueryParams;
import com.qiho.center.api.remoteservice.order.RemoteAfterSaleOrderService;
import com.qiho.center.biz.service.order.AfterSaleOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by danke on 2017/10/10.
 */
@RestController
public class RemoteAfterSaleOrderServiceImpl implements RemoteAfterSaleOrderService {


    @Autowired
    private AfterSaleOrderService afterSaleOrderService;

    @Override
    public String save(AfterSaleOrderDto afterSaleOrderDto,Long itemId) {
        return afterSaleOrderService.save(afterSaleOrderDto,itemId);
    }

    @Override
    public PagenationDto<AfterSaleOrderDto> queryAfterSaleByQuery(AfterSaleQueryParams params) {
        PagenationDto<AfterSaleOrderDto> resultBase = new PagenationDto<>();
        Integer count = afterSaleOrderService.countAfterSaleByQuery(params);
        resultBase.setTotal(count);
        if (count > 0){
            List<AfterSaleOrderDto> list = afterSaleOrderService.findAfterSaleByQuery(params);
            resultBase.setList(list);
        }
        return resultBase;
    }

    @Override
    public AfterSaleOrderDto queryAfterSaleByOrderId(String orderId) {
        return afterSaleOrderService.findByOrderId(orderId);
    }

    @Override
    public Boolean updateAfterSaleByDto(AfterSaleOrderDto afterSaleOrderDto) {
        return afterSaleOrderService.updateAfterSaleOrder(afterSaleOrderDto);
    }

    @Override
    public Boolean updateMetaValueByAfterSaleId(AfterSaleOrderDto afterSaleOrderDto) {
        return afterSaleOrderService.updateAfterSaleMetaValue(afterSaleOrderDto);
    }

    @Override
    public Boolean openAfterSale(String orderId) {
        return afterSaleOrderService.openAfterSale(orderId);
    }

    @Override
    public Boolean sponsorAfterSale(String orderId) {
        return afterSaleOrderService.sponsorAfterSale(orderId);
    }

    @Override
    public List<AfterSaleOrderDto> findAll(String orderId) {
        return afterSaleOrderService.findAll(orderId);
    }

    @Override
    public AfterSaleOrderDto queryAfterSaleById(String afterSaleId) {
        return afterSaleOrderService.queryAfterSaleById(afterSaleId);
    }

    @Override
    public List<AfterSaleOrderDto> queryAfterSaleByIds(List<String> afterSaleIds) {
        return afterSaleOrderService.queryAfterSaleByIds(afterSaleIds);
    }
}
