package com.qiho.center.biz.remoteservice.impl.tab;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.TabDto;
import com.qiho.center.api.remoteservice.RemoteTabService;
import com.qiho.center.biz.service.tab.TabService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by weny.cai on 2017/8/31.
 */
@RestController
public class RemoteTabServiceImpl implements RemoteTabService {

    private static Logger logger = LoggerFactory.getLogger(RemoteTabServiceImpl.class);

    @Resource
    TabService tabService;

    @Override
    public DubboResult<Integer> add(TabDto tabDto) {
        int result = 0;
        try {
            result = tabService.add(tabDto);
        }catch (Exception e){
            logger.error("invoke RemoteTabService.add failed, TabDto={}", tabDto, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<Integer> deleteList(List<Long> ids) {
        int result = 0;
        try{
            result = tabService.deleteList(ids);
        }catch (Exception e){
            logger.error("invoke RemoteTabService.deleteList failed, ids={}", ids, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<Integer> update(TabDto tabDto) {
        int result = 0;
        try{
            result = tabService.update(tabDto);
        }catch (Exception e){
            logger.error("invoke RemoteTabService.deleteList failed, TabDto={}", tabDto, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<TabDto> queryDetail(Long id) {
        TabDto tabDto = null;
        try{
            tabDto = tabService.queryDetail(id);
        }catch (Exception e){
            logger.error("invoke RemoteTabService.queryDetail failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(tabDto);
    }

    @Override
    public DubboResult<PagenationDto<TabDto>> queryList() {
        PagenationDto<TabDto> pagenation = null;
        try{
            pagenation = tabService.queryList();
        }catch (Exception e){
            logger.error("invoke RemoteTabService.queryDetail failed", e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(pagenation);
    }

    @Override
    public DubboResult<List<TabDto>> queryOnList() {
        List<TabDto> list = null;
        try {
            list = tabService.queryOnList();
        }catch (Exception e){
            logger.error("invoke RemoteTabService.queryOnList failed", e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(list);
    }

    @Override
    public DubboResult<Boolean> sortByPayLoad(Long sortId, Integer startPayload, Integer endPayload) {
        try{
            tabService.sortByPayLoad(sortId,startPayload,endPayload);
        }catch (Exception e){
            logger.error("invoke RemoteTabService.queryOnList failed", e);
            return DubboResult.failResult(e.getMessage());
        }
        return DubboResult.successResult(true);
    }

}
