package com.qiho.center.biz.runnable;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.biz.bo.ErpOrderBo;

@Component
@Scope("prototype")
public class BatchReviewFaildErpOrderRunnable implements Runnable {

    private Logger  logger    = LoggerFactory.getLogger(BatchReviewFaildErpOrderRunnable.class);

    @Autowired
    private ErpOrderBo erpOrderBo;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate   redisTemplate;

    private List<ErpOrderDto>    params = Lists.newArrayList();

    private BoundHashOperations<String, String, Object> ops;

    @Override
    public void run() {
        long failCount = 0L;
        try {
            for (ErpOrderDto param : params) {
                try {
                    Integer result = erpOrderBo.reviewFaildErpOrder(param);
                    if (result != 1) {
                        failCount++;
                    }
                } catch (Exception e) {
                    failCount++;
                    logger.error("审核erp子订单为失败状态异常", e);
                } finally {
                    ops.increment("successCount", 1L);
                }
            }
        } finally {
            ops.increment("failCount", failCount);
            ops.increment("taskCount", -1L);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = redisTemplate.boundHashOps(progressKey);
    }

    public void setParams(List<ErpOrderDto> params) {
        this.params.addAll(params);
    }

    /**
     * @return
     */
    public Integer enableFilter() {
        List<ErpOrderDto> newList = Lists.newArrayList();
        for (ErpOrderDto param : this.params) {
            if (StringUtils.isBlank(param.getErpId())) {
                continue;
            }
            newList.add(param);
        }
        params.clear();
        params.addAll(newList);
        return newList.size();
    }
}
