package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.engine.impl.ShotOrderEngine;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.util.AppLogUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by danke on 2017/6/
 * 过滤策略的任务类
 */
public class ShotOrderValuteRunnable implements Runnable{

    Logger logger = LoggerFactory.getLogger(getClass());

    private ShotOrderEngine shotOrderEngine;

    private QihoOrderSnapshotEntity qihoOrderSnapshotEntity;


    public ShotOrderValuteRunnable(ShotOrderEngine shotOrderEngine, QihoOrderSnapshotEntity qihoOrderSnapshotEntity) {
        this.shotOrderEngine = shotOrderEngine;
        this.qihoOrderSnapshotEntity = qihoOrderSnapshotEntity;
    }

    @Override
    public void run() {
        if (null == qihoOrderSnapshotEntity || null == shotOrderEngine)
            return;
        OrderSnapshotDto orderSnapshotDto = BeanUtils.copy(qihoOrderSnapshotEntity,OrderSnapshotDto.class);
        AppLogUtil.info(logger, "策略过滤任务创建 orderId={} qihoEntity={}",qihoOrderSnapshotEntity.getOrderId(),qihoOrderSnapshotEntity);
        shotOrderEngine.process(orderSnapshotDto);
    }

    public ShotOrderEngine getShotOrderEngine() {
        return shotOrderEngine;
    }

    public void setShotOrderEngine(ShotOrderEngine shotOrderEngine) {
        this.shotOrderEngine = shotOrderEngine;
    }

    public QihoOrderSnapshotEntity getQihoOrderSnapshotEntity() {
        return qihoOrderSnapshotEntity;
    }

    public void setQihoOrderSnapshotEntity(QihoOrderSnapshotEntity qihoOrderSnapshotEntity) {
        this.qihoOrderSnapshotEntity = qihoOrderSnapshotEntity;
    }
}
