package com.qiho.center.biz.service;

import com.qiho.center.api.dto.BannerDto;
import java.util.List;

/**
 * @author chensong
 * @create 2017-08-28 17:01
 **/
public interface BannerService {

    /**
     * 根据id查询banner
     * @param id
     * @return
     */
    BannerDto findById(Long id);

    /**
     * 获取所有的Banner、包含已过期、未到生效期的
     * @return
     */
    List<BannerDto> findAllBanners();

    /**
     * 获取所有在有效期的banner
     * @return
     */
    List<BannerDto> findValidBanners();

    /**
     * 新增、更新一条Banner
     * @return 受影响行数
     */
    int saveBanner(BannerDto dto);

    /**
     * 删除一条banner
     * @param id
     * @return 受影响行数
     */
    int deleteBanner(Long id);

    /**
     * 排序
     * @param idList
     * @return 排序的总条目
     */
    int sortBanner(String idList);

    /**
     * 统计Banner条目
     * @return
     */
    int countBanner();

    /**
     * 获取最大的payload值
     * @return
     */
    int findMaxPayload();


}
