package com.qiho.center.biz.service;

import com.qiho.center.api.dto.DetailRecommendDto;
import com.qiho.center.api.dto.ItemSimpleDto;

import java.util.List;

/**
 * Created by Administrator on 2017/9/20 0020.
 */
public interface DetailRecommendService {

    /**
     * 根据商品id查询推荐位
     * @param itemId
     * @return
     */
    List<DetailRecommendDto> findListByItemId(Long itemId);

    /**
     * 查询推荐位信息
     * @param itemId
     * @return
     */
    List<DetailRecommendDto> queryDetailRecommend(Long itemId);

    /**
     * 保存推荐位信息
     * @param dtos
     * @return
     */
    boolean saveDetailRecommend(List<DetailRecommendDto> dtos);

    /**
     * 查询商品信息
     * @param itemId
     * @return
     */
    ItemSimpleDto queryItemDetail(Long itemId);
}
