/**
 * Project Name:qiho-center-biz
 * File Name:TemplateService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年6月21日上午9:38:02
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service;

import com.qiho.center.api.dto.TemplateDto;

import java.util.List;

/**
 * ClassName:TemplateService <br/>
 * 模板管理服务. <br/>
 * Date:     2017年6月21日 上午9:38:02 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface TemplateService {

    /**
     * 模板开关
     *
     * @author zhanglihui
     * @param id
     * @param enable
     */
    void enableSwitch(Long id, Boolean enable);

    /**
     * 新增模板
     * @author zhanglihui
     * @param templateCode
     * @param templateName
     * @param templateContext
     */
    void addTemplate(String templateCode, String templateName, String templateContext,String noteTemplateId,String smsType);

    /**
     * 更新模板内容
     * @author zhanglihui
     * @param id
     * @param templateContext
     */
    void updateTemplate(Long id, String templateContext,String noteTemplateId,String smsType);

    /**
     * 查询模板列表
     * @author zhanglihui
     * @return List<TemplateDto>
     */
    List<TemplateDto> findTemplateList();

    /**
     * 根据模板代码查询模板内容
     *
     * @author zhanglihui
     * @param templateCode
     * @return 模板内容
     */
    TemplateDto findByCode(String templateCode);
}

