package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.constant.SystemConstant;
import com.qiho.center.api.dto.DetailRecommendDto;
import com.qiho.center.api.dto.DetailRecommendItemDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.DetailRecommendService;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qiho.QihoDetailRecommendMapper;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entityd.qiho.QihoDetailRecommendEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author chensong
 * @create 2017-09-20 14:07
 **/
@Service
public class DetailRecommendServiceImpl  implements DetailRecommendService{

    @Autowired
    private QihoDetailRecommendMapper qihoDetailRecommendMapper;

    @Autowired
    private ItemService itemService;

    @Autowired
    private ItemSaleCountService itemSaleCountService;

    @Autowired
    private QihoItemDAO qihoItemDAO;

    @Override
    public List<DetailRecommendDto> findListByItemId(Long itemId) {
        if(itemId == null || itemId <= 0){
            throw new QihoException("传入的itemId为空或小于0");
        }
        List<DetailRecommendDto> dtoList = BeanUtils.copyList(qihoDetailRecommendMapper.selectByItemId(itemId),DetailRecommendDto.class);
        if (CollectionUtils.isEmpty(dtoList)){
            return dtoList;
        }
        for (DetailRecommendDto dto : dtoList){
            Set<Long> ids = Stream.of(dto.getRecommendItemIds().split(",")).map(Long::valueOf).collect(Collectors.toSet());
            List<DetailRecommendItemDto> itemList = BeanUtils.copyList(itemService.findItemDtoByItemIds(ids),DetailRecommendItemDto.class);
            //商品销量
            List<Long> idList = Lists.newArrayList();
            idList.addAll(ids);
            Map<Long,Integer> saleNum = itemSaleCountService.queryItemSaleNum(idList);
            //商品推荐名称
            String[] recommendNames = dto.getRecommendItemNames().split(",");
            int index = 0;
            for (DetailRecommendItemDto item : itemList){
                item.setSaleNum(saleNum.get(item.getId()));
                item.setRecommendItemName(recommendNames[index]);
                index++;
            }
            dto.setItemList(itemList);
        }
        return dtoList;
    }

    @Override
    public List<DetailRecommendDto> queryDetailRecommend(Long itemId) {
        List<QihoDetailRecommendEntity> list = qihoDetailRecommendMapper.queryListByItemId(itemId);
        List<DetailRecommendDto> dtoList = Lists.newArrayList();
        for (QihoDetailRecommendEntity qihoDetailRecommendEntity : list) {
            Set<Long> ids = new HashSet<>();
            List<String> recommendItemIds =  Arrays.asList(qihoDetailRecommendEntity.getRecommendItemIds().split(","));
            for (String recommendItemId : recommendItemIds) {
                ids.add(Long.valueOf(recommendItemId));
            }
            List<ItemDto> itemDtos = itemService.findItemDtoByItemIds(ids);
            List<DetailRecommendItemDto> detailRecommendItemDtos = Lists.newArrayList();
            if(qihoDetailRecommendEntity.getRecommendItemNames()!=null){
                String[] names = qihoDetailRecommendEntity.getRecommendItemNames().split(",");
                for (int i = 0; i < itemDtos.size(); i++) {
                    ItemDto itemDto = itemDtos.get(i);
                    DetailRecommendItemDto detailRecommendItemDto = BeanUtils.copy(itemDto,DetailRecommendItemDto.class);
                    detailRecommendItemDto.setRecommendItemName(names[i]);
                    detailRecommendItemDtos.add(detailRecommendItemDto);
                }
            }
            DetailRecommendDto dto = BeanUtils.copy(qihoDetailRecommendEntity,DetailRecommendDto.class);
            dto.setItemList(detailRecommendItemDtos);
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    @Transactional
    public boolean saveDetailRecommend(List<DetailRecommendDto> dtos) {
        List<QihoDetailRecommendEntity> list = BeanUtils.copyList(dtos,QihoDetailRecommendEntity.class);
        int result = 0;
        for (QihoDetailRecommendEntity qihoDetailRecommendEntity : list) {
            int i;
            if(qihoDetailRecommendEntity.getId()==null){
                i = qihoDetailRecommendMapper.insert(qihoDetailRecommendEntity);
            }else{
                if(SystemConstant.ON.equals(qihoDetailRecommendEntity.getIsOpen())){
                    i = qihoDetailRecommendMapper.updateByPrimaryKeySelective(qihoDetailRecommendEntity);
                }else{
                    i = qihoDetailRecommendMapper.deleteByPrimaryKey(qihoDetailRecommendEntity.getId());
                }
            }
            result = result + i;
        }
        return result>0?true:false;
    }

    @Override
    public ItemSimpleDto queryItemDetail(Long itemId) {
        QihoItemDetailEntity qihoItemDetailEntity = qihoItemDAO.findById(itemId);
        return BeanUtils.copy(qihoItemDetailEntity,ItemSimpleDto.class);
    }

}
