package com.qiho.center.biz.service.impl;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.MainItemDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.MainItemService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.daoh.qiho.QihoMainItemMapper;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.QihoMainItemEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.javatuples.Pair;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Created by weny.cai on 2017/9/5.
 */
@Service
public class MainItemServiceImpl implements MainItemService {

    @Resource
    QihoMainItemMapper qihoMainItemMapper;

    @Resource
    QihoItemSkuDAO qihoItemSkuDAO;

    @Resource
    RemoteStockService remoteStockService;

    @Resource
    private ItemService itemService;

    @Autowired
    OrderSnapshotService orderSnapshotService;

    @Autowired
    ItemSaleCountService itemSaleCountService;


    @Override
    public int addMainItem(MainItemDto mainItemDto) {
        //判断主推商品是否已经存在
        QihoMainItemEntity mainItemEntity = BeanUtils.copy(mainItemDto,QihoMainItemEntity.class);
        int records = qihoMainItemMapper.selectByItemId(mainItemEntity);
        if(records>0){
            throw new QihoException("该商品主推已存在!");
        }
        //判断商品是否存在
        ItemSimpleDto itemSimpleDto = itemService.queryItemSimpleDto(mainItemDto.getItemId());
        if (itemSimpleDto == null){
            throw new QihoException("该商品不存在!");
        }
        int payload = qihoMainItemMapper.findMaxPlayload();
        mainItemEntity.setPayload(payload+1);
        return qihoMainItemMapper.insert(mainItemEntity);
    }

    @Override
    public int deleteMainItems(List<Long> ids) {
        return qihoMainItemMapper.deleteByPrimaryKeys(ids);
    }

    @Override
    public int editMainItem(MainItemDto mainItemDto) {
        QihoMainItemEntity mainItemEntiy = BeanUtils.copy(mainItemDto,QihoMainItemEntity.class);
        return qihoMainItemMapper.updateByPrimaryKeySelective(mainItemEntiy);
    }

    @Override
    public MainItemDto queryMainItem(Long id) {
        QihoMainItemEntity mainItemEntiy = qihoMainItemMapper.selectByPrimaryKey(id);
        return BeanUtils.copy(mainItemEntiy,MainItemDto.class);
    }

    @Override
    public PagenationDto<MainItemDto> queryMainItems() {
        PagenationDto<MainItemDto> pagenation = new PagenationDto<>();
        List<QihoMainItemEntity> list = qihoMainItemMapper.queryByParam();
        if(!list.isEmpty()){
            countSkuStock(list);//计算库存  最小价格
            //计算总销量
            pagenation.setList(convertToMainItemDto(list));
        }else{
            pagenation.setList(Lists.newArrayList());
        }
        return pagenation;
    }

    @Override
    public void sortMainItem(Long mainIitemId, Integer originPayload, Integer newPayload) {
        if (originPayload == newPayload){
            return;
        }
        Map<String,Integer> param = new HashMap<>();
        if(originPayload > newPayload){
            param.put("biggerPayload",originPayload);
            param.put("samllerPayload",newPayload);
        } else {
            param.put("biggerPayload",newPayload);
            param.put("samllerPayload",originPayload);
        }
        List<QihoMainItemEntity> entityList = qihoMainItemMapper.selectBetweenPayload(param);
        //更新被拖动节点的payload值
        QihoMainItemEntity entity = new QihoMainItemEntity();
        entity.setId(mainIitemId);
        entity.setPayload(newPayload);
        qihoMainItemMapper.updatePayloadById(entity);
        List<Long> idList = Lists.newArrayList();
        for (QihoMainItemEntity mainItem : entityList){
            if(mainItem.getId() != mainIitemId){
                idList.add(mainItem.getId());
            }
        }
        int offset = originPayload > newPayload ? 1 : -1;
        Map<String,Object> updateParam = new HashMap<>();
        updateParam.put("idList",idList);
        updateParam.put("offset",offset);
        qihoMainItemMapper.updatePayloadBatch(updateParam);
    }

    @Override
    public PagenationDto<MainItemDto> queryVaildList() {
        PagenationDto<MainItemDto> pagenation = new PagenationDto<>();
        List<QihoMainItemEntity> list = qihoMainItemMapper.queryVaildList();
        if(!list.isEmpty()){
            countSkuStock(list);//计算库存  最小价格
            vaildStock(list);
            //计算总销量
            pagenation.setList(convertToMainItemDto(list));
        }else{
            pagenation.setList(Lists.newArrayList());
        }
        return pagenation;
    }

    private void vaildStock(List<QihoMainItemEntity> list) {
        Iterator<QihoMainItemEntity> it = list.iterator();
        while (it.hasNext()){
            QihoMainItemEntity entity = it.next();
            if(entity.getStock()==0){
                it.remove();
            }
        }
    }

    /**
     * 计算库存
     * 最小价格
     * 总销量
     * @param list
     */
    private void countSkuStock(List<QihoMainItemEntity> list) {
        List<Long> idList = Lists.newArrayList();
        for (QihoMainItemEntity qihoMainItemEntity : list) {
            idList.add(qihoMainItemEntity.getItemId());
        }
        List<QihoItemSkuEntity> skuList = qihoItemSkuDAO.getSkuByItemIds(idList);
        List<Long> stockIds = Lists.newArrayList();
        for (QihoItemSkuEntity skuEntity : skuList) {
            stockIds.add(skuEntity.getStockId());
        }
        // stockId : 库存 键值对
        Map<Long, Long> stockMap = remoteStockService.findBatch(stockIds).getResult();
        Pair<Map,Map> stockPair = getSkuStockInfo(stockMap,skuList);
        Map<Long, Long> enableStock = stockPair.getValue1();
        //价格
        Pair<Map,Map> pricePair = getSkuPriceInfo(skuList);
        // itemId: 最小价格
        Map<Long, Integer> minPriceMap = pricePair.getValue0();

        Iterator<QihoMainItemEntity> it = list.iterator();
        Map<Long, Integer> batchMap = itemSaleCountService.queryItemSaleNum(idList);
        while (it.hasNext()){
            QihoMainItemEntity mainItemEntiy = it.next();
            Long stock = enableStock.get(mainItemEntiy.getItemId());
            Integer minPrice = minPriceMap.get(mainItemEntiy.getItemId());
            mainItemEntiy.setStock(stock == null ? 0:stock);
            mainItemEntiy.setSaleNumStr(batchMap.get(mainItemEntiy.getItemId()));
            mainItemEntiy.setMinPrice(minPrice);
        }
    }

    private List<MainItemDto> convertToMainItemDto(List<QihoMainItemEntity> list) {
        List<MainItemDto> result = Lists.newArrayList();
        for (QihoMainItemEntity qihoMainItemEntity : list) {
            MainItemDto mainItemDto = BeanUtils.copy(qihoMainItemEntity,MainItemDto.class);
            result.add(mainItemDto);
        }
        return result;
    }

    private Pair<Map,Map> getSkuPriceInfo(List<QihoItemSkuEntity> skuList) {
        // itemId: 最小价格
        Map<Long, Integer> minPriceMap = Maps.newHashMap();
        // itemId: 最小原价
        Map<Long, Integer> minOriginalPriceMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            Long itemId = skuEntity.getItemId();
            // 商品最小价格
            Integer minPrice = minPriceMap.get(itemId);
            Integer sellingPrice = skuEntity.getSellingPrice() == null ? 0 : skuEntity.getSellingPrice();
            minPriceMap.put(itemId,minPrice == null ? sellingPrice : Math.min(minPrice, sellingPrice));
            // 商品最小原价
            Integer minOriginalPrice = minOriginalPriceMap.get(itemId);
            Integer originalPrice = skuEntity.getOriginalPrice() == null ? 0 : skuEntity.getOriginalPrice();
            minOriginalPriceMap.put(itemId,minOriginalPrice == null ? originalPrice : Math.min(minOriginalPrice, originalPrice));
        }
        return Pair.with(minPriceMap,minOriginalPriceMap);
    }

    private Pair<Map,Map> getSkuStockInfo(Map<Long, Long> stockMap, List<QihoItemSkuEntity> skuList) {
        // itemId : 库存 键值对
        Map<Long, Long> itemStockMap = Maps.newHashMap();
        //有效库存
        Map<Long,Long> itemEnableStockMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            // sku库存
            Long stock = stockMap.get(skuEntity.getStockId());
            if (stock == null || stock <= 0) {
                stock = 0l;
            }
            Long itemId = skuEntity.getItemId();
            // 商品总库存
            Long itemStock = itemStockMap.get(itemId);
            itemStockMap.put(itemId,itemStock == null ? stock : itemStock + stock);
            if(skuEntity.getSkuEnable()){
                Long itemEnableStock = itemEnableStockMap.get(itemId);
                itemEnableStockMap.put(itemId,itemEnableStock==null ? stock : itemEnableStock + stock);
            }
        }
        return Pair.with(itemStockMap,itemEnableStockMap);
    }
}
