package com.qiho.center.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.params.QuerySkinParams;
import com.qiho.center.biz.service.SkinService;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoSkinDAO;
import com.qiho.center.common.entity.QihoSkinEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Date:     2017/7/5 11:12 <br/>
 *
 * @author huika
 * @see
 */
@Service
public class SkinServiceImpl implements SkinService {

    private Logger logger = LoggerFactory.getLogger(SkinServiceImpl.class);

    @Autowired
    private QihoSkinDAO skinDAO;

    @Autowired
    private TestMetadataService testMetadataService;

    @Override
    public PagenationDto<SkinDto> queryAllSkin(QuerySkinParams params) {
        List<SkinDto> skinDtoList = Lists.transform(skinDAO.queryAllSkin(params), this::convertDto);
        Integer count = skinDAO.countAllSkin(params);
        PagenationDto<SkinDto> pagenationDto = new PagenationDto<>();
        pagenationDto.setList(skinDtoList);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    @Override
    public SkinDto querySkinById(Long id) {
        return convertDto(skinDAO.querySkinById(id));
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Long createSkin(SkinDto entity) {
        if(null==entity){
            return 0L;
        }
        //皮肤新增后,测试元数据需要新增
        Long skinId = skinDAO.createSkin(convertEntity(entity));
        try {
            TestMetadataDto testMetadataDto = new TestMetadataDto();
            testMetadataDto.setItemId(0L);
            testMetadataDto.setMetadataKey(MetadataTypeEnum.SKIN.getCode());
            testMetadataDto.setMetadataValue(skinId.toString());
            testMetadataDto.setDataName(entity.getSkinName());
            testMetadataDto.setDataDesc(entity.getSkinName());
            testMetadataService.saveMetadata(testMetadataDto);
        } catch (Exception e) {
            logger.error("SkinServiceImpl createSkin call saveMetadata error,param={}", JSON.toJSONString(entity),e);
        }
        return skinId;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public int updateSkin(SkinDto entity) {
        if(null==entity){
            return 0;
        }
        return skinDAO.updateSkin(convertEntity(entity));
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public int deleteSkin(Long id) {
        //删除皮肤对应的测试数据
        testMetadataService.deleteSkinTestMetadata(id);
        return skinDAO.deleteSkin(id);
    }

    private SkinDto convertDto(QihoSkinEntity entity) {
        if (entity == null) {
            return null;
        }
        SkinDto skinDto = new SkinDto();
        BeanUtils.copyProperties(entity, skinDto);
        skinDto.setGmtModified(entity.getGmtModified().getTime());
        return skinDto;
    }

    private QihoSkinEntity convertEntity(SkinDto dto) {
        QihoSkinEntity entity = new QihoSkinEntity();
        BeanUtils.copyProperties(dto, entity);
        return entity;
    }
}
