package com.qiho.center.biz.service.impl.abtest;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qiho.QihoMetadataDetailMapper;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanMapper;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoMetadataDetailEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestMetadataEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanEntity;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/10/10.
 */
@Service
public class TestMetadataServiceImpl implements TestMetadataService {

	@Resource
    QihoTestMetadataMapper  qihoTestMetadataMapper;

	@Resource
	QihoMetadataDetailMapper qihoMetadataDetailMappler;

	@Resource
	QihoTestPlanMapper   qihoTestPlanMapper;

	@Resource
	ItemService itemService;

	@Resource
	private QihoItemDAO qihoItemDAO;

	@Override
	@Transactional(DsConstants.DATABASE_QIHO)
	public int saveMetadata(TestMetadataDto dto) throws BizException {
		MetadataTypeEnum type = MetadataTypeEnum.getByCode(dto.getMetadataKey());
		if(null==type){
			throw new BizException("无效的元数据类型");
		}
		QihoTestMetadataEntity entity = BeanUtils.copy(dto,QihoTestMetadataEntity.class);
		validateInfo(entity);
		//如果是详情,需要先存储详情的信息
		if(type.equals(MetadataTypeEnum.DETAIL)){
			QihoMetadataDetailEntity detailEntity = new QihoMetadataDetailEntity();
			detailEntity.setItemId(entity.getItemId());
			detailEntity.setDetailText(entity.getMetadataValue());
			qihoMetadataDetailMappler.insert(detailEntity);
			entity.setMetadataValue(detailEntity.getId()+"");
		}
		return qihoTestMetadataMapper.insert(entity);
	}

	public void validateInfo(QihoTestMetadataEntity entity) throws BizException {
		//查询名称是否存在
		Map<String,Object> param = Maps.newHashMap();
		param.put("dataName",entity.getDataName());
		param.put("metadataKey",entity.getMetadataKey());
		List<QihoTestMetadataEntity> list   = qihoTestMetadataMapper.selectListByField(param);
		if(CollectionUtils.isEmpty(list)){
			return;
		}
		if(null == entity.getId() || entity.getId()==0){
			throw new BizException("名称不能重复");
		}
		for(QihoTestMetadataEntity dataEntity:list){
			if(!dataEntity.getId().equals(entity.getId())){
				throw new BizException("名称不能重复");
			}
		}
	}

	@Override
	@Transactional(DsConstants.DATABASE_QIHO)
	public int updateMetadata(TestMetadataDto dto) throws BizException {
		MetadataTypeEnum type = MetadataTypeEnum.getByCode(dto.getMetadataKey());
		QihoTestMetadataEntity entity = BeanUtils.copy(dto,QihoTestMetadataEntity.class);
		validateInfo(entity);
		//如果是详情,需要先存储详情的信息
		if(type.equals(MetadataTypeEnum.DETAIL)){
			QihoTestMetadataEntity oldEntity = qihoTestMetadataMapper.selectById(dto.getId());
			QihoMetadataDetailEntity detailEntity = new QihoMetadataDetailEntity();
			detailEntity.setItemId(entity.getItemId());
			detailEntity.setDetailText(entity.getMetadataValue());
			detailEntity.setId(Long.valueOf(oldEntity.getMetadataValue()));
			qihoMetadataDetailMappler.update(detailEntity);
			entity.setMetadataValue(detailEntity.getId()+"");
		}
		return qihoTestMetadataMapper.update(entity);
	}

	@Override
	public TestMetadataDto selectById(Long id) {
		QihoTestMetadataEntity entity = qihoTestMetadataMapper.selectById(id);
		TestMetadataDto dto = BeanUtils.copy(entity,TestMetadataDto.class);
		if(Objects.equal(MetadataTypeEnum.DETAIL,MetadataTypeEnum.getByCode(dto.getMetadataKey()))){
			QihoMetadataDetailEntity detailEntity = qihoMetadataDetailMappler.selectById(Long.valueOf(dto.getMetadataValue()));
			dto.setMetadataValue(detailEntity.getDetailText());
			dto.setMetadataDetailId(detailEntity.getId());
		}
		return dto;
	}


	@Override
	public List<TestMetadataDto> selectListByTypeAndItemId(Long itemId, String metadataKey) {
		List<TestMetadataDto> resultList = Lists.newArrayList();
		Map<String,Object> param = Maps.newHashMap();
		if(StringUtils.equals(metadataKey,MetadataTypeEnum.SKIN.getCode())){
			param.put("itemId",0L);
		}else{
			param.put("itemId",itemId);
		}
		param.put("metadataKey",metadataKey);
		List<QihoTestMetadataEntity> list = qihoTestMetadataMapper.selectListByField(param);
		if(CollectionUtils.isEmpty(list)){
			return resultList;
		}
		list.stream().forEach(entity->{
			resultList.add(BeanUtils.copy(entity,TestMetadataDto.class));
		});
		return  resultList;
	}

	@Override
	public PagenationDto<TestMetadataDto> queryListByPage(TestMetadataQueryParam param) throws BizException {
		//查询一下商品
		ItemDetailDto itemDetailDto = itemService.queryItemDetail(param.getItemId());
		if(null==itemDetailDto){
			throw new BizException("没有找到该商品");
		}
		PagenationDto<TestMetadataDto> page = new PagenationDto<>();
		int count = qihoTestMetadataMapper.selectListCountByPage(param);
		page.setTotal(count);
		if(count ==0 ){
			return page;
		}
		List<TestMetadataDto> pageList = Lists.newArrayList();
		List<QihoTestMetadataEntity> list = qihoTestMetadataMapper.selectListByPage(param);
		list.stream().forEach(entity->{
			TestMetadataDto dto = BeanUtils.copy(entity,TestMetadataDto.class);
			dto.setItemName(itemDetailDto.getItemName());
			dto.setPicUrl(itemDetailDto.getExtParam().get("image"));
			if(StringUtils.equals(dto.getMetadataKey(),MetadataTypeEnum.DETAIL.getCode())){
				QihoMetadataDetailEntity detailEntity = qihoMetadataDetailMappler.selectById(Long.valueOf(dto.getMetadataValue()));
				dto.setMetadataValue(detailEntity.getDetailText());
				dto.setMetadataDetailId(detailEntity.getId());
				pageList.add(dto);
			}
		});
		page.setList(pageList);
		return page;
	}

	@Override
	public int deleteMetadata(Long id) throws BizException {
		//校验当前数据是否已经被测试计划使用
		List<QihoTestPlanEntity> list = qihoTestPlanMapper.selectValidPlanCountByMetadataId(id);
		if(CollectionUtils.isNotEmpty(list)){
			throw  new BizException("本详情已被用于测试方案【"+list.get(0).getPlanName()+"】，不允许删除");
		}
		return qihoTestMetadataMapper.deleteById(id);
	}

	@Override
	public boolean syncToItemInfo(Long id,Long modifyId) throws BizException {
		QihoTestMetadataEntity entity = qihoTestMetadataMapper.selectById(id);
		if(null==entity || entity.getIsDelete()==1){
			throw new BizException("记录不存在或已删除");
		}
		ItemSimpleDto itemSimpleDto = itemService.queryItemSimpleDto(entity.getItemId());
		if(null==itemSimpleDto){
			throw new BizException("商品不存在");
		}
		//如果是详情页同步
		if(StringUtils.equals(entity.getMetadataKey(),MetadataTypeEnum.DETAIL.getCode())){
			ItemAdvertDto itemAdvertDto = itemService.queryExtParamByItemId(entity.getItemId());
			QihoMetadataDetailEntity detailEntity = qihoMetadataDetailMappler.selectById(Long.valueOf(entity.getMetadataValue()));
			itemAdvertDto.setDetail(detailEntity.getDetailText());
			itemService.updateExtParamByItemId(itemAdvertDto);
			QihoItemEntity itemEntity = new QihoItemEntity();
			itemEntity.setId(entity.getItemId());
			itemEntity.setGmtModifier(modifyId);
			qihoItemDAO.update(itemEntity);
		}
		return true;
	}

	@Override
	public void deleteSkinTestMetadata(Long skinId) {
		//查询一下当前皮肤是不是被使用中
		Map<String,Object> map = Maps.newHashMap();
		map.put("metadataKey",MetadataTypeEnum.SKIN.getCode());
		map.put("metadataValue",skinId.toString());
		List<QihoTestMetadataEntity> entityList = qihoTestMetadataMapper.selectListByField(map);
		if(CollectionUtils.isEmpty(entityList)){
			return;
		}
		QihoTestMetadataEntity metadataEntity =entityList.get(0);
		//查询一下是否有有效数据
		List<QihoTestPlanEntity> list = qihoTestPlanMapper.selectValidPlanCountByMetadataId(metadataEntity.getId());
		if(CollectionUtils.isNotEmpty(list)){
			throw new QihoException("该皮肤被应用于测试计划["+list.get(0).getPlanName()+"],不能删除");
		}
		qihoTestMetadataMapper.deleteById(metadataEntity.getId());
	}
}
