package com.qiho.center.biz.service.impl.order;
/**
 * Created by Administrator on 2017/10/11 0011.
 */

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.constant.AfterSaleConstant;
import com.qiho.center.api.dto.AfterSaleOrderDto;
import com.qiho.center.api.dto.AfterSaleStageDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.AfterSaleQueryParams;
import com.qiho.center.biz.service.order.AfterSaleOrderService;
import com.qiho.center.common.dao.QihoAfterSaleOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.entity.order.QihoAfterSaleOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2017-10-11 14:18
 **/
@Service
public class AfterSaleOrderServiceImpl implements AfterSaleOrderService {

    @Autowired
    private QihoAfterSaleOrderDAO  qihoAfterSaleOrderDAO;

    @Autowired
    private QihoOrderDAO           qihoOrderDAO;

    @Autowired
    private SequenceNoBuilder sequenceNoBuilder;

    @Override
    public AfterSaleOrderDto findByOrderId(String orderId) {
        QihoAfterSaleOrderEntity entity = qihoAfterSaleOrderDAO.findByOrderId(orderId);
        return convertToDto(entity);
    }

    @Override
    public Boolean updateAfterSaleOrder(AfterSaleOrderDto dto) {
        QihoAfterSaleOrderEntity entity = BeanUtils.copy(dto,QihoAfterSaleOrderEntity.class);
        return qihoAfterSaleOrderDAO.updateAfterSaleOrder(entity) > 0;
    }

    @Override
    public Boolean updateAfterSaleMetaValue(AfterSaleOrderDto dto) {
        QihoAfterSaleOrderEntity entity = BeanUtils.copy(dto,QihoAfterSaleOrderEntity.class);
        JSONObject extjson = new JSONObject();
        String detailStageStr = JSONObject.toJSONString(dto.getDetailStage());
        extjson.put(AfterSaleConstant.DETAIL_STAGE,detailStageStr);
        entity.setMetaValue(extjson.toJSONString());
        return qihoAfterSaleOrderDAO.updateAfterSaleMetaValue(entity) > 0;
    }

    @Override
    public Boolean openAfterSale(String orderId) {
        return qihoAfterSaleOrderDAO.findByOrderId(orderId) != null;
    }

    @Override
    public Boolean sponsorAfterSale(String orderId) {
        // 主订单状态交易成功
        QihoOrderEntity order = qihoOrderDAO.findByOrderId(orderId);
        if (!StringUtils.equals(order.getOrderStatus(), OrderStatusEnum.SUCCESS.getCode())){
            return Boolean.FALSE;
        }
        // 交易成功不超过31天
        long days = (new Date().getTime() - order.getGmtModified().getTime())/(1000*60*60*24);
        if (days >= 31){
            return Boolean.FALSE;
        }
        // 不存在未完成（待审核|待确认|售后中）的售后子订单
        QihoAfterSaleOrderEntity afterSaleOrder  = qihoAfterSaleOrderDAO.findUnfinished(orderId);
        if (afterSaleOrder != null){
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public List<AfterSaleOrderDto> findAll(String orderId) {
        List<QihoAfterSaleOrderEntity> entityList = qihoAfterSaleOrderDAO.findAll(orderId);
        if (CollectionUtils.isEmpty(entityList)){
            return Lists.newArrayList();
        }
        // 类型转换
        return entityList.stream().map(this::convertToDto).collect(Collectors.toList());
    }

    @Override
    public List<AfterSaleOrderDto> findAfterSaleByQuery(AfterSaleQueryParams params) {
        List<QihoAfterSaleOrderEntity> entities = qihoAfterSaleOrderDAO.findAfterSaleByQuery(params);
        if (CollectionUtils.isEmpty(entities)){
            return Lists.newArrayList();
        }
        List<AfterSaleOrderDto> afterSaleOrderList = BeanUtils.copyList(entities,AfterSaleOrderDto.class);
        afterSaleOrderList.forEach(e -> e.setDetailStage(parseStrToJson(AfterSaleConstant.DETAIL_STAGE,e.getMetaValue(),AfterSaleStageDto.class)));
        return afterSaleOrderList;
    }

    @Override
    public Integer countAfterSaleByQuery(AfterSaleQueryParams params) {
        return qihoAfterSaleOrderDAO.countAfterSaleByQuery(params);
    }

    @Override
    public String save(AfterSaleOrderDto dto,Long itemId) {
        QihoAfterSaleOrderEntity entity = BeanUtils.copy(dto,QihoAfterSaleOrderEntity.class);
        String afterSaleId = sequenceNoBuilder.createSeqNo(SeqBizTypeEnum.AFTER_SALE, itemId);
        entity.setAfterSaleId(afterSaleId);
        qihoAfterSaleOrderDAO.save(entity);
        return afterSaleId;
    }

    @Override
    public AfterSaleOrderDto queryAfterSaleById(String afterSaleId) {
        return qihoAfterSaleOrderDAO.queryAfterSaleById(afterSaleId);
    }

    @Override
    public List<AfterSaleOrderDto> queryAfterSaleByIds(List<String> afterSaleIds) {
        return qihoAfterSaleOrderDAO.queryAfterSaleByIds(afterSaleIds);
    }

    /**
     * 处理扩展字段转换为对应的类型
     * @param metaValue
     * @return
     */
    private <T> List<T> parseStrToJson(String key,String metaValue,Class<T> clazz){
        if (StringUtils.isBlank(key) || StringUtils.isBlank(metaValue) || null == clazz)
            return new ArrayList<>();
        JSONObject extJson = JSONObject.parseObject(metaValue);

        String stageStr =  extJson.getString(key);

        if(StringUtils.isNotBlank(stageStr)){
            return JSONArray.parseArray(stageStr,clazz);
        }
        return new ArrayList<>();
    }

    private AfterSaleOrderDto convertToDto(QihoAfterSaleOrderEntity entity){
        AfterSaleOrderDto dto = BeanUtils.copy(entity,AfterSaleOrderDto.class);
        String mateValue = entity.getMetaValue();
        if (StringUtils.isNotBlank(mateValue)){
            dto.setDetailStage(parseStrToJson(AfterSaleConstant.DETAIL_STAGE,mateValue,AfterSaleStageDto.class));
        }
        return dto;
    }

}
