/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.ErpTypeEnum;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.bo.OrderBo;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.dao.QihoOrderItemInfoDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderItemInfoEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.ERPClientUtil;
import com.qiho.center.common.util.EdbLib;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@BizEventListener
public class ErpOrderBo {
    private static final Logger LOG = LoggerFactory.getLogger(ErpOrderBo.class);
    @Autowired
    private ErpOrderService erpOrderService;
    @Autowired
    private OrderBo orderBo;
    @Autowired
    private OrderService orderService;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoOrderItemInfoDAO qihoOrderItemInfoDAO;
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Autowired
    private FundOrderService fundOrderService;
    @Resource
    private ExecutorService executorService;
    @Value(value="${qiho.erp.shop.no}")
    private String shopNo;
    @Value(value="${qiho.erp.auto.reliver.url}")
    private String erpAutoReliverUrl;
    private ListeningExecutorService service;
    @Autowired
    private EdbLib edbLib;
    @Autowired
    private ConfigService configService;
    private static final String CANCEL_SEND_TEXT = "\u624b\u52a8\u53d1\u8d27-\u53d6\u6d88\u53d1\u8d27";
    public String numAndLetterRegEx = "^[A-Za-z0-9]{1,40}$";
    @Autowired
    KuaiDi100Bo kuaiDi100Bo;
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;

    @PostConstruct
    public void init() {
        this.service = MoreExecutors.listeningDecorator((ExecutorService)this.executorService);
    }

    @Transactional(value="QIHO")
    public void cancelDeliver(String erpId) {
        this.checkEnableErpOrder(erpId);
        ErpOrderDto erpOrderDto = this.erpOrderService.updateErpStatus(erpId, ErpStatusEnum.FAILED, ErpStatusEnum.TO_NOTIFY, "\u53d6\u6d88\u53d1\u8d27");
        if (Objects.equal((Object)erpOrderDto.getErpType(), (Object)ErpTypeEnum.SEND.getCode())) {
            this.orderBo.rejectOrder(erpOrderDto.getOrderId(), CANCEL_SEND_TEXT, null);
        }
        this.refund(erpOrderDto.getOrderId());
    }

    private void refund(String orderId) {
        List<FundOrderDto> list = this.fundOrderService.findByOrderIdAndBizType(orderId, FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isEmpty(list)) {
            throw new QihoException("\u6570\u636e\u5f02\u5e38\uff0c\u4ed8\u6b3e\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderId=" + orderId);
        }
        FundOrderDto fundOrder = list.get(0);
        if (StringUtils.equals((CharSequence)fundOrder.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
            fundOrder.setFundStatus(FundStatusEnum.FAILED.getCode());
            this.fundOrderService.update(fundOrder);
            QihoOrderSnapshotEntity order = new QihoOrderSnapshotEntity();
            order.setOrderId(orderId);
            order.setFundStatus(FundStatusEnum.FAILED.getCode());
            this.qihoOrderSnapshotDAO.updataFundInfo(order);
        } else if (!StringUtils.equals((CharSequence)fundOrder.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) && StringUtils.equals((CharSequence)fundOrder.getFundStatus(), (CharSequence)FundStatusEnum.SUCCESS.getCode())) {
            this.fundOrderService.refund(fundOrder.getOrderId(), fundOrder.getPayType(), fundOrder.getAmt());
        }
    }

    @Transactional(value="QIHO")
    public void resolveDeliver(ResolveDeliverParams params) {
        Pattern pat = Pattern.compile(this.numAndLetterRegEx, 2);
        Matcher matcher = pat.matcher(params.getExpressCode());
        boolean rs = matcher.matches();
        if (!rs) {
            throw new QihoException("\u5feb\u9012\u5355\u53f7\u683c\u5f0f\u6709\u8bef\uff0c\u53ea\u80fd\u662f\u6570\u5b57\u6216\u8005\u6570\u5b57\u52a0\u5b57\u6bcd!");
        }
        LogisticsOrderEntity logisticsOrderEntity = this.qihoLogisticsOrderDAO.findByErpId(params.getErpId());
        if (logisticsOrderEntity != null) {
            LogisticsOrderEntity entity = new LogisticsOrderEntity();
            entity.setPostId(params.getExpressCode());
            entity.setLogisticsName(params.getQihoExpressEnum().getName());
            entity.setErpId(params.getErpId());
            this.qihoLogisticsOrderDAO.updateLogistics(entity);
            QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
            orderSnapshot.setPostId(params.getExpressCode());
            orderSnapshot.setLogisticsName(params.getQihoExpressEnum().getName());
            orderSnapshot.setLogisticsCode(params.getQihoExpressEnum().getCode());
            orderSnapshot.setOrderId(logisticsOrderEntity.getOrderId());
            this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
            ArrayList list = Lists.newArrayList();
            LogisticsOrderEntity logisticsOrderEntity1 = new LogisticsOrderEntity();
            logisticsOrderEntity1.setLogisticsCode(params.getQihoExpressEnum().getCode());
            logisticsOrderEntity1.setPostId(params.getExpressCode());
            list.add(logisticsOrderEntity1);
            this.kuaiDi100Bo.dealpostOrder(list);
        } else {
            this.checkEnableErpOrder(params.getErpId());
            ErpOrderDto erpOrderDto = this.erpOrderService.updateErpStatus(params.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
            this.logisticsOrderService.initLogisticsOrder(erpOrderDto, params);
        }
    }

    private void checkEnableErpOrder(String erpId) {
        ErpOrderDto erpOrder = this.erpOrderService.findErpOrderByErpId(erpId);
        if (erpOrder == null) {
            throw new QihoException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.equals((CharSequence)erpOrder.getErpStatus(), (CharSequence)ErpStatusEnum.TO_NOTIFY.getCode())) {
            throw new QihoException("\u8ba2\u5355\u975e\u5f85\u901a\u77e5\u72b6\u6001");
        }
        if (!StringUtils.equals((CharSequence)erpOrder.getDelivery(), (CharSequence)DeliveryEnum.MANUAL.getCode())) {
            throw new QihoException("\u8ba2\u5355\u975e\u624b\u52a8\u53d1\u8d27\u65b9\u5f0f");
        }
    }

    public void autoDelivery(QihoErpOrderEntity erp) {
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(erp.getOrderId());
        if (!StringUtils.equals((CharSequence)order.getOrderStatus(), (CharSequence)OrderStatusEnum.TO_SEND.getCode())) {
            AppLogUtil.warn((Logger)LOG, (String)"\u8ba2\u5355\u975e\u4ee3\u53d1\u8d27\u72b6\u6001\uff0c\u3010orderId={}, orderStatus={}\u3011", (Object[])new Object[]{order.getOrderId(), order.getOrderStatus()});
            return;
        }
        String erpManufacturerType = this.configService.findByName("ERP_MANUFACTURER_TYPE");
        if (Objects.equal((Object)erpManufacturerType, (Object)ErpManufacturerType.EDB.getCode())) {
            AutoEDianBaoReliverRunnable runnable = new AutoEDianBaoReliverRunnable(erp, order);
            AutoErpEDianBaoFutureCallback callback = new AutoErpEDianBaoFutureCallback();
            callback.setQihoErpOrderEntity(erp);
            ListenableFuture future = this.service.submit((Callable)runnable);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)callback);
        } else if (Objects.equal((Object)erpManufacturerType, (Object)ErpManufacturerType.WDT.getCode())) {
            AutoErpReliverRunnable runnable = new AutoErpReliverRunnable(erp, order);
            AutoErpReliverFutureCallback callback = new AutoErpReliverFutureCallback();
            callback.setQihoErpOrderEntity(erp);
            ListenableFuture future = this.service.submit((Callable)runnable);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)callback);
        } else {
            LOG.warn("ERP\u5382\u5546\u4e0d\u5b58\u5728  \u6570\u636e\u5e93\u914d\u7f6e\u6709\u8bef:{}", (Object)erpManufacturerType);
            return;
        }
    }

    @Transactional(value="QIHO")
    public Integer reviewFaildErpOrder(ErpOrderDto dto) {
        LogisticsOrderDto logisticsOrderDto = this.logisticsOrderService.findByErpId(dto.getErpId());
        if (logisticsOrderDto != null) {
            return 0;
        }
        ErpOrderDto updatedto = this.erpOrderService.updateErpStatus(dto.getErpId(), ErpStatusEnum.FAILED, ErpStatusEnum.SUCCESS, dto.getFailedMessage());
        if (updatedto == null) {
            return 0;
        }
        this.closeOrder(updatedto.getOrderId(), dto.getFailedMessage());
        return 1;
    }

    private void closeOrder(String orderId, String remark) {
        this.orderBo.rejectOrder(orderId, remark, OrderApprovalStatusEnum.APPROVE_FAILD);
        this.refund(orderId);
    }

    private class AutoErpReliverFutureCallback
    implements FutureCallback<JSONObject> {
        private QihoErpOrderEntity qihoErpOrderEntity;

        private AutoErpReliverFutureCallback() {
        }

        @Transactional(value="QIHO")
        public void onSuccess(JSONObject result) {
            if (result.getInteger("code") != 0) {
                String errorMessage = "ERP\u81ea\u52a8\u53d1\u8d27\u8fd4\u56de\u5931\u8d25";
                ErpOrderBo.this.erpOrderService.updateErpStatus(this.qihoErpOrderEntity.getErpId(), ErpStatusEnum.FAILED, ErpStatusEnum.TO_NOTIFY, errorMessage);
                ErpOrderBo.this.closeOrder(this.qihoErpOrderEntity.getOrderId(), errorMessage);
                LOG.error("ERP\u81ea\u52a8\u53d1\u8d27\u8fd4\u56de\u5931\u8d25:" + result.getString("message"));
            } else {
                ErpOrderBo.this.erpOrderService.updateErpStatus(this.qihoErpOrderEntity.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
            }
        }

        public void onFailure(Throwable t) {
            LOG.error("ERP\u8ba2\u5355\u81ea\u52a8\u53d1\u8d27\u8bf7\u6c42\u5931\u8d25,ERP={}", (Object)this.qihoErpOrderEntity.getErpId(), (Object)t);
        }

        public void setQihoErpOrderEntity(QihoErpOrderEntity qihoErpOrderEntity) {
            this.qihoErpOrderEntity = qihoErpOrderEntity;
        }
    }

    private class AutoErpReliverRunnable
    implements Callable<JSONObject> {
        private QihoErpOrderEntity qihoErpOrderEntity;
        private QihoOrderSnapshotEntity qihoOrderSnapshotEntity;

        public AutoErpReliverRunnable(QihoErpOrderEntity qihoErpOrderEntity, QihoOrderSnapshotEntity qihoOrderSnapshotEntity) {
            this.qihoErpOrderEntity = qihoErpOrderEntity;
            this.qihoOrderSnapshotEntity = qihoOrderSnapshotEntity;
        }

        @Override
        public JSONObject call() {
            Map<String, String> params = this.getParams();
            String result = ERPClientUtil.execute((String)ErpOrderBo.this.erpAutoReliverUrl, params);
            return JSONObject.parseObject((String)result);
        }

        private Map<String, String> getParams() {
            HashMap parmas = Maps.newHashMap();
            parmas.put("shop_no", ErpOrderBo.this.shopNo);
            JSONArray tradeList = new JSONArray();
            JSONObject tradeItem = new JSONObject();
            tradeItem.put("tid", (Object)this.qihoErpOrderEntity.getErpId());
            tradeItem.put("trade_status", (Object)30);
            int payStatus = 0;
            int deliveryTerm = 2;
            float codAmount = (float)this.qihoOrderSnapshotEntity.getOrderAmt().intValue() / 100.0f;
            float paid = 0.0f;
            if (!StringUtils.equals((CharSequence)this.qihoOrderSnapshotEntity.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
                payStatus = 2;
                deliveryTerm = 1;
                codAmount = 0.0f;
                paid = (float)this.qihoOrderSnapshotEntity.getOrderAmt().intValue() / 100.0f;
            }
            tradeItem.put("pay_status", (Object)payStatus);
            tradeItem.put("delivery_term", (Object)deliveryTerm);
            tradeItem.put("trade_time", (Object)DateUtils.getSecondStr((Date)this.qihoErpOrderEntity.getGmtCreate()));
            tradeItem.put("buyer_nick", (Object)this.qihoErpOrderEntity.getConsumerName());
            tradeItem.put("receiver_name", (Object)this.qihoErpOrderEntity.getConsumerName());
            tradeItem.put("receiver_province", (Object)this.qihoErpOrderEntity.getProvince());
            tradeItem.put("receiver_city", (Object)this.qihoErpOrderEntity.getCity());
            tradeItem.put("receiver_district", (Object)this.qihoErpOrderEntity.getDistrict());
            tradeItem.put("receiver_address", (Object)this.qihoErpOrderEntity.getAddress());
            tradeItem.put("receiver_mobile", (Object)this.qihoErpOrderEntity.getMobile());
            tradeItem.put("logistics_type", (Object)4);
            tradeItem.put("buyer_message", (Object)this.qihoOrderSnapshotEntity.getMessage());
            tradeItem.put("post_amount", (Object)0);
            tradeItem.put("cod_amount", (Object)Float.valueOf(codAmount));
            tradeItem.put("ext_cod_fee", (Object)0);
            tradeItem.put("other_amount", (Object)0);
            tradeItem.put("paid", (Object)Float.valueOf(paid));
            JSONArray orderList = new JSONArray();
            JSONObject orderItem = new JSONObject();
            QihoOrderItemInfoEntity orderItemInfo = ErpOrderBo.this.qihoOrderItemInfoDAO.findByOrderId(this.qihoOrderSnapshotEntity.getOrderId());
            orderItem.put("oid", (Object)(this.qihoErpOrderEntity.getErpId() + "-1"));
            orderItem.put("num", (Object)orderItemInfo.getQuantity());
            orderItem.put("price", (Object)Float.valueOf((float)orderItemInfo.getSellingPrice().intValue() / 100.0f));
            orderItem.put("status", (Object)10);
            orderItem.put("refund_status", (Object)0);
            orderItem.put("goods_id", (Object)orderItemInfo.getItemId());
            orderItem.put("spec_id", (Object)orderItemInfo.getSkuId());
            orderItem.put("goods_no", (Object)orderItemInfo.getItemNo());
            orderItem.put("goods_name", (Object)orderItemInfo.getItemName());
            orderItem.put("spec_no", (Object)orderItemInfo.getSkuNo());
            orderItem.put("spec_name", (Object)orderItemInfo.getSkuName());
            orderItem.put("cid", (Object)1);
            orderList.add((Object)orderItem);
            tradeItem.put("order_list", (Object)orderList);
            tradeList.add((Object)tradeItem);
            parmas.put("trade_list", tradeList.toJSONString());
            return parmas;
        }
    }

    private class AutoErpEDianBaoFutureCallback
    implements FutureCallback<JSONObject> {
        private QihoErpOrderEntity qihoErpOrderEntity;

        private AutoErpEDianBaoFutureCallback() {
        }

        @Transactional(value="QIHO")
        public void onSuccess(JSONObject result) {
            if (result.get((Object)"Success") == null) {
                String errorMessage = "ERP\u81ea\u52a8\u53d1\u8d27\u8fd4\u56de\u5931\u8d25";
                ErpOrderBo.this.erpOrderService.updateErpStatus(this.qihoErpOrderEntity.getErpId(), ErpStatusEnum.FAILED, ErpStatusEnum.TO_NOTIFY, errorMessage);
                ErpOrderBo.this.closeOrder(this.qihoErpOrderEntity.getOrderId(), errorMessage);
                LOG.error("ERP\u81ea\u52a8\u53d1\u8d27\u8fd4\u56de\u5931\u8d25:" + result.getString("message"));
            } else {
                ErpOrderBo.this.erpOrderService.updateErpStatus(this.qihoErpOrderEntity.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
            }
        }

        public void onFailure(Throwable t) {
            LOG.error("ERP\u8ba2\u5355\u81ea\u52a8\u53d1\u8d27\u8bf7\u6c42\u5931\u8d25,ERP={}", (Object)this.qihoErpOrderEntity.getErpId(), (Object)t);
        }

        public void setQihoErpOrderEntity(QihoErpOrderEntity qihoErpOrderEntity) {
            this.qihoErpOrderEntity = qihoErpOrderEntity;
        }
    }

    private class AutoEDianBaoReliverRunnable
    implements Callable<JSONObject> {
        private QihoErpOrderEntity qihoErpOrderEntity;
        private QihoOrderSnapshotEntity qihoOrderSnapshotEntity;

        public AutoEDianBaoReliverRunnable(QihoErpOrderEntity qihoErpOrderEntity, QihoOrderSnapshotEntity qihoOrderSnapshotEntity) {
            this.qihoErpOrderEntity = qihoErpOrderEntity;
            this.qihoOrderSnapshotEntity = qihoOrderSnapshotEntity;
        }

        @Override
        public JSONObject call() {
            Map params = ErpOrderBo.this.edbLib.edbGetCommonParams("edbTradeAdd");
            params.put("xmlValues", this.getParams());
            String result = ErpOrderBo.this.edbLib.edbRequstPost(params);
            return JSONObject.parseObject((String)result);
        }

        private String getParams() {
            StringBuilder builder = new StringBuilder();
            builder.append("<info>");
            builder.append("<orderInfo>");
            builder.append("<out_tid>" + this.qihoErpOrderEntity.getErpId() + "</out_tid>");
            builder.append("<shop_id>1</shop_id>");
            builder.append("<buyer_id>" + this.qihoErpOrderEntity.getConsumerName() + "</buyer_id>");
            builder.append("<buyer_msg>" + this.qihoOrderSnapshotEntity.getMessage() + "</buyer_msg>");
            builder.append("<consignee>" + this.qihoErpOrderEntity.getConsumerName() + "</consignee>");
            builder.append("<mobilPhone>" + this.qihoErpOrderEntity.getMobile() + "</mobilPhone>");
            builder.append("<privince>" + this.qihoErpOrderEntity.getProvince() + "</privince>");
            builder.append("<city>" + this.qihoErpOrderEntity.getCity() + "</city>");
            builder.append("<area>" + this.qihoErpOrderEntity.getDistrict() + "</area>");
            builder.append("<address>" + this.qihoErpOrderEntity.getAddress() + "</address>");
            String payStatus = "\u672a\u4ed8\u6b3e";
            int deliveryTerm = 1;
            if (!StringUtils.equals((CharSequence)this.qihoOrderSnapshotEntity.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
                deliveryTerm = 0;
                payStatus = "\u5df2\u4ed8\u6b3e";
            }
            float codAmount = (float)this.qihoOrderSnapshotEntity.getOrderAmt().intValue() / 100.0f;
            builder.append("<actual_freight_get>0</actual_freight_get>");
            builder.append("<is_COD>" + deliveryTerm + "</is_COD>");
            builder.append("<order_totalMoney>" + codAmount + "</order_totalMoney>");
            builder.append("<product_totalMoney>" + codAmount + "</product_totalMoney>");
            builder.append("<order_date>" + DateUtils.getSecondStr((Date)this.qihoErpOrderEntity.getGmtCreate()) + "</order_date>");
            builder.append("<express>\u4eac\u4e1c\u5feb\u9012</express>");
            builder.append("<pay_status>" + payStatus + "</pay_status>");
            builder.append("</orderInfo>");
            QihoOrderItemInfoEntity orderItemInfo = ErpOrderBo.this.qihoOrderItemInfoDAO.findByOrderId(this.qihoOrderSnapshotEntity.getOrderId());
            builder.append("<product_info>");
            builder.append("<product_item>");
            builder.append("<barCode>" + orderItemInfo.getSkuNo() + "</barCode>");
            builder.append("<product_title>" + orderItemInfo.getItemName() + "</product_title>");
            builder.append("<orderGoods_Num>" + orderItemInfo.getQuantity() + "</orderGoods_Num>");
            builder.append("<cost_Price>" + (float)orderItemInfo.getSellingPrice().intValue() / 100.0f + "</cost_Price>");
            builder.append("<out_tid>" + this.qihoErpOrderEntity.getErpId() + "</out_tid>");
            builder.append("</product_item>");
            builder.append("</product_info>");
            builder.append("</info>");
            return builder.toString();
        }
    }
}

