/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.jd.open.api.sdk.response.etms.LdopReceiveTraceGetResponse;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.JDLogisticsOrderStatusEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.biz.service.impl.LogisticsOrderServiceImpl;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.util.JDClientUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JDLogisticsSyncBo {
    private static final Logger logger = LoggerFactory.getLogger(JDLogisticsSyncBo.class);
    private static final String RESPONSE_SUCCESS_CODE = "0";
    @Autowired
    JDClientUtil jdClientUtil;
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
    @Autowired
    LogisticsOrderServiceImpl logisticsOrderService;

    public void syncLogisticsOrderStatus(List<LogisticsOrderEntity> list) {
        for (LogisticsOrderEntity entity : list) {
            if (StringUtils.isBlank((CharSequence)entity.getPostId())) continue;
            try {
                LdopReceiveTraceGetResponse response = this.jdClientUtil.executeLdopReceiveTrace(entity.getPostId());
                List sendList = response.getQuerytraceResult().getData();
                if (RESPONSE_SUCCESS_CODE.equals(response.getCode()) && CollectionUtils.isNotEmpty((Collection)sendList)) {
                    TraceDTO traceDTO = (TraceDTO)sendList.get(sendList.size() - 1);
                    this.updateJdStatus(entity, traceDTO);
                }
                Thread.sleep(100L);
            }
            catch (JdException e) {
                logger.warn("\u4eac\u4e1c\u7269\u6d41\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void updateJdStatus(LogisticsOrderEntity entity, TraceDTO traceDTO) throws JdException {
        if (traceDTO == null) {
            return;
        }
        JDLogisticsOrderStatusEnum statusEnum = JDLogisticsOrderStatusEnum.getByDesc((String)traceDTO.getOpeTitle());
        String orderStatus = statusEnum == null ? null : statusEnum.getCode();
        String logisticsStatusDesc = null;
        if (!traceDTO.getWaybillCode().equals(entity.getPostId())) {
            LdopReceiveTraceGetResponse returnResponse = this.jdClientUtil.executeLdopReceiveTrace(traceDTO.getWaybillCode());
            List returnList = returnResponse.getQuerytraceResult().getData();
            if (RESPONSE_SUCCESS_CODE.equals(returnResponse.getCode()) && CollectionUtils.isNotEmpty((Collection)returnList)) {
                TraceDTO returnTraceDTO = (TraceDTO)returnList.get(returnList.size() - 1);
                logisticsStatusDesc = returnTraceDTO.getOpeTitle();
                orderStatus = JDLogisticsOrderStatusEnum.JD_SUCCESS.getDesc().equals(logisticsStatusDesc) ? LogisticsOrderStatusEnum.RETURN.getCode() : LogisticsOrderStatusEnum.REJECTED.getCode();
            }
        } else {
            logisticsStatusDesc = traceDTO.getOpeTitle();
        }
        if (!StringUtils.equals((CharSequence)entity.getOrderStatus(), (CharSequence)orderStatus)) {
            entity.setLogisticsStatus(logisticsStatusDesc);
            entity.setOrderStatus(orderStatus);
            LogisticsOrderDto dto = (LogisticsOrderDto)BeanUtils.copy((Object)entity, LogisticsOrderDto.class);
            this.logisticsOrderService.update(dto);
        }
    }
}

