/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.KuaiDi100LogisticsEnum;
import com.qiho.center.api.enums.KuaiDi100LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.KuaiDi100OrderStatusEnum;
import com.qiho.center.biz.service.impl.LogisticsOrderServiceImpl;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.params.kuaidi100.Result;
import com.qiho.center.common.params.kuaidi100.ResultItem;
import com.qiho.center.common.params.kuaidi100.TaskResponse;
import com.qiho.center.common.util.KuaiDi100Util;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KuaiDi100Bo {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuaiDi100Bo.class);
    @Resource
    private LogisticsOrderServiceImpl logisticsOrderService;
    @Resource
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;

    public Boolean dealKuaiDi100Status(String com, String postId, String status, String condition) {
        LogisticsOrderDto dto = new LogisticsOrderDto();
        KuaiDi100LogisticsOrderStatusEnum kuaiDi100LogisticsOrderStatusEnum = KuaiDi100LogisticsOrderStatusEnum.getByState((String)status);
        if (kuaiDi100LogisticsOrderStatusEnum != null) {
            dto.setLogisticsStatus(kuaiDi100LogisticsOrderStatusEnum.getDesc());
        } else {
            dto.setLogisticsStatus(status);
        }
        KuaiDi100OrderStatusEnum statusEnum = KuaiDi100OrderStatusEnum.getByKuaiDi100Status((String)status);
        if (statusEnum == null) {
            return true;
        }
        if (statusEnum == KuaiDi100OrderStatusEnum.UNDER_WAY && "JQ001".equals(condition)) {
            dto.setOrderStatus(KuaiDi100OrderStatusEnum.REJECTED.getStatus());
        } else {
            dto.setOrderStatus(statusEnum.getStatus());
        }
        dto.setPostId(postId);
        KuaiDi100LogisticsEnum logisticsEnum = KuaiDi100LogisticsEnum.getByKuaiDi100Code((String)com);
        if (logisticsEnum == null) {
            LOGGER.error("\u5feb\u9012100\u63a8\u9001\u7684\u5feb\u9012\u516c\u53f8\u4ee3\u7801\u4e0d\u5b58\u5728\u6620\u5c04\u679a\u4e3e\u4e2d:", (Object)com);
            return false;
        }
        dto.setLogisticsCode(logisticsEnum.getCode());
        this.logisticsOrderService.update(dto);
        return true;
    }

    public void dealpostOrder(List<LogisticsOrderEntity> list) {
        List groupList = Lists.partition(list, (int)20);
        for (List listFinal : groupList) {
            long start = System.currentTimeMillis();
            for (LogisticsOrderEntity entity : listFinal) {
                KuaiDi100LogisticsEnum logistics = KuaiDi100LogisticsEnum.getByCode((String)entity.getLogisticsCode());
                if (logistics == null) {
                    LOGGER.error("\u5728\u5feb\u9012100\u679a\u4e3e\u6620\u5c04\u4e2d\u4e0d\u5b58\u5728\u5feb\u9012\u516c\u53f8\u4ee3\u7801:{}", (Object)entity.getLogisticsCode());
                    continue;
                }
                this.postOrder(logistics.getKuaiDi100Code(), entity.getPostId());
            }
            long end = System.currentTimeMillis();
            long useTime = end - start;
            if (useTime >= 1000L) continue;
            try {
                Thread.sleep(1000L - useTime);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Thread sleep error ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void postOrder(String kuaiDi100Code, String postId) {
        TaskResponse response = KuaiDi100Util.postOrder((String)kuaiDi100Code, (String)postId);
        if (response != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response.getReturnCode())) {
            this.qihoLogisticsOrderDAO.updatePostReturnCode(Integer.parseInt(response.getReturnCode()), postId);
        }
    }

    public List<LogisticsProcessDto> queryWaybillTrace(String logisticsCode, String postId) {
        ArrayList resultList = Lists.newArrayList();
        if (StringUtils.isBlank((String)postId)) {
            return resultList;
        }
        try {
            Result result = KuaiDi100Util.queryWaybillTrace((String)logisticsCode, (String)postId);
            if (null != result && result.getData() != null) {
                ArrayList list = result.getData();
                for (ResultItem resultItem : list) {
                    LogisticsProcessDto logisticsProcessDto = new LogisticsProcessDto();
                    logisticsProcessDto.setWaybillNo(postId);
                    logisticsProcessDto.setUploadTime(resultItem.getFtime());
                    logisticsProcessDto.setProcessInfo(resultItem.getContext());
                    resultList.add(logisticsProcessDto);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5feb\u9012100\u8fd0\u5355\u8d70\u4ef6\u6d41\u7a0b\u5f02\u5e38\uff0c postId = " + postId, (Throwable)e);
        }
        return resultList;
    }
}

