/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncAckDto;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.biz.runnable.LogisticsOrderSignRunnable;
import com.qiho.center.biz.service.EdbApiService;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.ERPClientUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class LogisticsOrderBo
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(LogisticsOrderBo.class);
    private static final String QUERY_ERP_LOGISTICS_SYNC_LIMIT = "100";
    private static final String IS_PART_SYNC_ABLE = "0";
    private ApplicationContext context;
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Resource
    private ExecutorService executorService;
    @Resource
    private EdbApiService edbApiService;

    public void erpLogisticsSyncQuery() {
        while (true) {
            HashMap params = Maps.newHashMap();
            params.put("shop_no", ERPClientUtil.getShopNo());
            params.put("limit", QUERY_ERP_LOGISTICS_SYNC_LIMIT);
            params.put("is_part_sync_able", IS_PART_SYNC_ABLE);
            String logisticsJson = null;
            Boolean brokenStatus = Boolean.FALSE;
            List<ErpLogisticsSyncDto> list = null;
            try {
                logisticsJson = ERPClientUtil.execute((String)ERPClientUtil.getLogisticsSyncUrl(), (Map)params);
                list = this.getLogisticsOrderDtoList(logisticsJson);
                if (CollectionUtils.isEmpty(list)) {
                    LOG.info("ERP\u7cfb\u7edf\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5b8c\u6210\u3002\u65e0\u5f85\u540c\u6b65\u7269\u6d41\u4fe1\u606f");
                    brokenStatus = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                LOG.error("ERP\u7cfb\u7edf\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
                brokenStatus = Boolean.TRUE;
            }
            if (brokenStatus.booleanValue()) break;
            List<ErpLogisticsSyncAckDto> listReurn = this.logisticsOrderService.createLogisticsOrderBatch(list);
            if (!CollectionUtils.isNotEmpty(listReurn)) continue;
            HashMap returnParams = Maps.newHashMap();
            returnParams.put("logistics_list", JSON.toJSONString(listReurn));
            try {
                ERPClientUtil.execute((String)ERPClientUtil.getLogisticsAckUrl(), (Map)returnParams);
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                LOG.error("\u8fd4\u56deERP\u7cfb\u7edf\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5904\u7406\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void edbErpLogisticsSyncQuery() {
        List<ErpLogisticsSyncDto> items;
        int pageNo = 1;
        SimpleDateFormat fd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        String endTime = fd.format(calendar.getTime());
        if (hour == 9) {
            calendar.add(10, -14);
        } else {
            calendar.add(10, -1);
            calendar.add(12, -30);
        }
        String beginTime = fd.format(calendar.getTime());
        while (!CollectionUtils.isEmpty(items = this.edbApiService.edbTradeGet(pageNo, QUERY_ERP_LOGISTICS_SYNC_LIMIT, beginTime, endTime))) {
            this.logisticsOrderService.createLogisticsOrderBatch(items);
            ++pageNo;
        }
    }

    public List<ErpLogisticsSyncDto> getLogisticsOrderDtoList(String logisticsJson) {
        ArrayList list = Lists.newArrayList();
        try {
            if (StringUtils.isBlank((String)logisticsJson)) {
                return ListUtils.EMPTY_LIST;
            }
            JSONObject json = JSON.parseObject((String)logisticsJson);
            String code = json.getString("code");
            if (!StringUtils.equals((String)code, (String)ErpErrorCodeReturnEnum.SUCCESS.getCode())) {
                return ListUtils.EMPTY_LIST;
            }
            JSONArray temp = JSON.parseArray((String)json.get((Object)"trades").toString());
            if (CollectionUtils.isEmpty((Collection)temp)) {
                return ListUtils.EMPTY_LIST;
            }
            for (int j = 0; j < temp.size(); ++j) {
                JSONObject t = temp.getJSONObject(j);
                ErpLogisticsSyncDto queryLogisticsReturnDto = (ErpLogisticsSyncDto)JSON.toJavaObject((JSON)t, ErpLogisticsSyncDto.class);
                LogisticsNameEnum logisticsName = LogisticsNameEnum.getByName((String)queryLogisticsReturnDto.getLogisticsName());
                if (logisticsName != null) {
                    queryLogisticsReturnDto.setLogisticsCode(logisticsName.getCode());
                }
                list.add(queryLogisticsReturnDto);
            }
        }
        catch (Exception e) {
            AppLogUtil.warn((Logger)LOG, (String)"\u540c\u6b65\u7269\u6d41\u8ba2\u5355\u5931\u8d25", (Object[])new Object[]{e});
            return ListUtils.EMPTY_LIST;
        }
        return list;
    }

    public Integer batchSignOrder(String progressKey, List<LogisticsOrderDto> paramList) {
        LogisticsOrderSignRunnable runnable = (LogisticsOrderSignRunnable)this.context.getBean(LogisticsOrderSignRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(paramList);
        int enableCount = runnable.enableFilter();
        this.executorService.submit(runnable);
        return enableCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }
}

