/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.WdtOrderAuditParams;
import com.qiho.center.biz.event.OrderClosedEvent;
import com.qiho.center.biz.runnable.AuditOrderRunnable;
import com.qiho.center.biz.runnable.WdtAuditOrderRunnable;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.support.BizEventBus;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderBo
implements ApplicationContextAware {
    private ApplicationContext context;
    @Resource
    private ExecutorService executorService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderSnapshotService orderSnapshotService;
    @Autowired
    private BizEventBus bizEventBus;

    public Integer batchAuditOrder(String progressKey, List<OrderAuditParams> paramList) {
        AuditOrderRunnable runnable = (AuditOrderRunnable)this.context.getBean(AuditOrderRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(paramList);
        int enableCount = runnable.enableFilter();
        this.executorService.submit(runnable);
        return enableCount;
    }

    public int wdtBatchAuditOrder(String progressKey, List<WdtOrderAuditParams> list) {
        WdtAuditOrderRunnable runnable = (WdtAuditOrderRunnable)this.context.getBean(WdtAuditOrderRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(list);
        this.executorService.submit(runnable);
        return list.size();
    }

    public void updateOrderStatus(String orderId, OrderStatusEnum orderStatus) {
        this.orderService.updateOrderStatus(orderId, orderStatus);
        this.orderSnapshotService.updateOrderStatus(orderId, null, orderStatus, null);
    }

    @Transactional(value="QIHO")
    public void rejectOrder(String orderId, String remark, OrderApprovalStatusEnum orderApprovalStatusEnum) {
        this.orderService.rejectOrder(orderId, remark, orderApprovalStatusEnum);
        this.orderSnapshotService.updateOrderStatus(orderId, remark, OrderStatusEnum.CLOSED, orderApprovalStatusEnum);
        OrderClosedEvent orderClosedEvent = new OrderClosedEvent();
        orderClosedEvent.setOrderId(orderId);
        this.bizEventBus.post((Object)orderClosedEvent);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }
}

